/***************************************************************************
                          clientview.cpp  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qwidgetstack.h>

#include <kglobal.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "clientview.h"

ClientView::ClientView(QWidget *parent, const char *name)
           : KSetiSpyView(Text, parent, name)
{
  QBoxLayout *layout = new QVBoxLayout(this);
  layout->setSpacing(8);

  layout->addWidget(addField(this, "ClientView::client"));
  setFieldName("ClientView::client", i18n("SETI@home client: Version"));

  layout->addWidget(addField(this, "ClientView::url"));
  setFieldName("ClientView::url", i18n("URL:"));

  layout->addWidget(addField(this, "ClientView::OS"));
  setFieldName("ClientView::OS", i18n("Operating system:"));

  layout->addWidget(addField(this, "ClientView::memory"));
  setFieldName("ClientView::memory", i18n("Physical memory size:"));

  layout->addWidget(addField(this, "ClientView::swap"));
  setFieldName("ClientView::swap", i18n("Swap space size:"));

  layout->addStretch(1);

  QBoxLayout *hbox = new QHBoxLayout(layout);

  hbox->addStretch(1);

  KPushButton *controlButton = new KPushButton(i18n("&Start"), this, "ClientView::client_control");
  controlButton->installEventFilter(this);
  hbox->addWidget(controlButton);
  connect(controlButton, SIGNAL(clicked()), this, SLOT(handleClient()));

  CacheManager *manager = kdoc->getCacheManager();
  connect(manager, SIGNAL(updated()), this, SLOT(updateContent()));

  updateContent(false);
}

ClientView::~ClientView()
{
}

void ClientView::updateContent(bool force)
{
  // optimization: do not update if this is not the visible widget
  const QWidgetStack *views = (QWidgetStack *) this->parent();
  if(views->visibleWidget() != this && !force) return;

  KLocale *locale = KGlobal::locale();
  SetiClientMonitor *monitor = kdoc->setiMonitor();

  if(monitor != NULL && monitor->currentState() > SetiClientMonitor::No_Data)
  {
    const version_info versionInfo = monitor->setiData()->version;
    const double version = versionInfo.major + 1e-2 * versionInfo.minor;
    setFieldContentText("ClientView::client",
                        i18n("%1 (text version)").arg(locale->formatNumber(version, 2)));
  } else
    setFieldContentText("ClientView::client", i18n(unknownContent));

  if(monitor != NULL)
    setFieldContentText("ClientView::url", monitor->url().prettyURL(+1, KURL::StripFileProtocol));
  else
    setFieldContentText("ClientView::url", i18n(unknownContent));

  const sys_info *info = (monitor != NULL) ? monitor->sysInfo() : NULL;

  if(info != NULL && !info->kernel.name.isEmpty())
    setFieldContentText("ClientView::OS", info->kernel.name);
  else
    setFieldContentText("ClientView::OS", i18n(unknownContent));

  if(info != NULL &&  info->memory.overall.total >= 0L)
    setFieldContentText("ClientView::memory", SysInfoMonitor::kbToString(info->memory.overall.total));
  else
    setFieldContentText("ClientView::memory", i18n(unknownContent));

  if(info != NULL && info->memory.swap.total >= 0L)
    setFieldContentText("ClientView::swap", SysInfoMonitor::kbToString(info->memory.swap.total));
   else
    setFieldContentText("ClientView::swap", i18n(unknownContent));

  KPushButton *controlButton = (KPushButton *) child("ClientView::client_control", "KPushButton");

  if(monitor != NULL && monitor->isRunning())
    controlButton->setText(i18n("&Stop"));
  else
    controlButton->setText(i18n("&Start"));
  controlButton->setEnabled(monitor != NULL && !monitor->command().isEmpty());
}

void ClientView::handleClient()
{
  SetiClientMonitor *monitor = kdoc->setiMonitor();
  if(monitor == NULL) return;

  if(monitor->isRunning())
    monitor->kill();
  else
    monitor->exec();
}

#include "clientview.moc"

