/***************************************************************************
                          cachelogdialog.h  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CACHELOGDIALOG_H
#define CACHELOGDIALOG_H

#include "cachemanager.h"
#include "ksetispyview.h"

class CacheLogDialog : public KSetiSpyView  {
  Q_OBJECT
  public:
    CacheLogDialog(QWidget *parent, const char *name=0);
    ~CacheLogDialog();
  public slots:
    virtual void readConfig(bool readGeometry);
    virtual void saveConfig(bool saveGeometry);
    virtual void logStart(CacheManager::ConnectionType type, uint n);
    virtual void logEnd(CacheManager::ConnectionType type);
    virtual void logInput(const QString& input, CacheManager::ConnectionType type);
    virtual void logOutput(const QString& output, CacheManager::ConnectionType type);
  protected slots:
    virtual void textToClipboard();
    virtual void killProcess();
  private:
    QString getTextID(CacheManager::ConnectionType type) const;
};

#endif
