/***************************************************************************
                          cachelogdialog.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qclipboard.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qregexp.h>
#include <qtextview.h>
#include <qwidgetstack.h>

#include <kapplication.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "cachelogdialog.h"

const int CacheLogMaxLength = 200;

CacheLogDialog::CacheLogDialog(QWidget *parent, const char *name)
               : KSetiSpyView(Text, parent, name)
{
  setCaption(i18n("Connection Log"));

  QBoxLayout *layout = new QVBoxLayout(this, 8, 8);

  QBoxLayout *hbox;

  hbox = new QHBoxLayout();
  layout->addLayout(hbox);

  QLabel *label = new QLabel(i18n("View:"), this);
  hbox->addWidget(label);

  label->installEventFilter(this);

  QButtonGroup *buttongroup = new QButtonGroup(this, "CacheLogDialog::view");
  buttongroup->setExclusive(true);
  buttongroup->hide();

  QRadioButton *radio;

  radio = new QRadioButton(i18n("&Downloads"), this, "CacheLogDialog::view_downloads");
  hbox->addWidget(radio);

  radio->installEventFilter(this);
  buttongroup->insert(radio, 0);

  radio = new QRadioButton(i18n("&Uploads"), this, "ProfileDialog::view_uploads");
  hbox->addWidget(radio);

  radio->installEventFilter(this);
  buttongroup->insert(radio, 1);

  hbox->addStretch(1);

  QWidgetStack *stack = new QWidgetStack(this, "CacheLogDialog::stack");
  layout->addWidget(stack, 1);

  const QFontMetrics fontMetrics = this->fontMetrics();
  QTextView *text;

  text = new QTextView(this, "CacheLogDialog::downloads");
  text->setMinimumWidth(fontMetrics.maxWidth() * 40);
  text->viewport()->installEventFilter(this);
  stack->addWidget(text, CacheManager::Download);

  text = new QTextView(this, "CacheLogDialog::uploads");
  text->setMinimumWidth(fontMetrics.maxWidth() * 40);
  text->viewport()->installEventFilter(this);
  stack->addWidget(text, CacheManager::Upload);

  buttongroup->setButton(0);
  stack->raiseWidget(CacheManager::Download);
  connect(buttongroup, SIGNAL(clicked(int)), stack, SLOT(raiseWidget(int)));

  hbox = new QHBoxLayout();
  layout->addLayout(hbox, 0);

  KPushButton *button;

  button = new KPushButton(i18n("&Kill Connection"), this, "CacheLogDialog::kill");
  button->installEventFilter(this);
  hbox->addWidget(button, 0);

  connect(button, SIGNAL(clicked()), this, SLOT(killProcess()));

  hbox->addStretch(1);

  CacheManager *manager = kdoc->getCacheManager();

  connect(manager, SIGNAL(startConnect(CacheManager::ConnectionType, uint)),
          this, SLOT(logStart(CacheManager::ConnectionType, uint)));
  connect(manager, SIGNAL(endConnect(CacheManager::ConnectionType)),
          this, SLOT(logEnd(CacheManager::ConnectionType)));
  connect(manager, SIGNAL(input(const QString&, CacheManager::ConnectionType)),
          this, SLOT(logInput(const QString&, CacheManager::ConnectionType)));
  connect(manager, SIGNAL(output(const QString&, CacheManager::ConnectionType)),
          this, SLOT(logOutput(const QString&, CacheManager::ConnectionType)));
}

CacheLogDialog::~CacheLogDialog()
{
}

void CacheLogDialog::readConfig(bool readGeometry)
{
  if(!readGeometry) return;

  KConfig *config = kapp->config();
  QRect rect;

  config->setGroup("Connection Log Dialog");

  rect = this->geometry();
  setGeometry(config->readRectEntry("Geometry", &rect));
}

void CacheLogDialog::saveConfig(bool saveGeometry)
{
  if(!saveGeometry) return;

  KConfig *config = kapp->config();

  config->setGroup("Connection Log Dialog");

  config->writeEntry("Geometry", this->geometry());
}

void CacheLogDialog::logStart(CacheManager::ConnectionType type, uint n)
{
  QTextView *text = (QTextView *) child(getTextID(type), "QTextView");
  QString message;

  if(type == CacheManager::Download)
    message = i18n("Downloading item %1 of the cache...").arg(n);
  else
    message = i18n("Uploading item %1 of the cache...").arg(n);
  message = "<p><b>" + message + "</b></p><p>";
  text->setText(message);
}

void CacheLogDialog::logEnd(CacheManager::ConnectionType type)
{
  QTextView *text = (QTextView *) child(getTextID(type), "QTextView");
  QString message = i18n("Process has been terminated");

  message = "</p><p><b>" + message + "</b></p>";
  text->setText(text->text() + message);
}

void CacheLogDialog::logInput(const QString& input, CacheManager::ConnectionType type)
{
  QTextView *text = (QTextView *) child(getTextID(type), "QTextView");
  QString message = QString("<font color=\"#999999\">%1</font></p><p>").arg(input);

  text->setText(text->text() + message);
}

void CacheLogDialog::logOutput(const QString& output, CacheManager::ConnectionType type)
{
  QTextView *text = (QTextView *) child(getTextID(type), "QTextView");
  QString message = output;

  message.replace(QRegExp("\n"), "</p><p>");
  text->setText(text->text() + message);
}

void CacheLogDialog::textToClipboard()
{
  const QWidgetStack *stack = (QWidgetStack *) child("CacheLogDialog::stack");
  const QTextView *text = (QTextView *) stack->visibleWidget();
  QString out = text->text();

  out.replace(QRegExp("</p>"), "\n");
  out.replace(QRegExp("<[^>]*>"), "");

  KApplication::clipboard()->setText(out);
}

void CacheLogDialog::killProcess()
{
  const QWidgetStack *stack = (QWidgetStack *) child("CacheLogDialog::stack");
  const int type = stack->id(stack->visibleWidget());

  CacheManager *manager = kdoc->getCacheManager();
  manager->kill(CacheManager::ConnectionType(type));
}

QString CacheLogDialog::getTextID(CacheManager::ConnectionType type) const
{
  return(QString("CacheLogDialog::%1").arg(type == CacheManager::Download ? "downloads" : "uploads"));
}

#include "cachelogdialog.moc"

