/***************************************************************************
                          aboutview.cpp  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by Roberto Virga
    email                : rvirga@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>

#include <kaboutdata.h>          
#include <kapplication.h>
#include <klocale.h>
#include <kpushbutton.h>
               
#include <config.h>

#include "aboutview.h"

const QString  AuthorEMail    = "rvirga@users.sourceforge.net";
const QString SetiURL        = I18N_NOOP("http://setiathome.ssl.berkeley.edu/");

AboutView::AboutView(QWidget *parent, const char *name)
          : KSetiSpyView(Text, parent, name)
{
  QBoxLayout *layout = new QBoxLayout(this, QBoxLayout::TopToBottom);
  layout->setSpacing(8);

  layout->addWidget(addField(this, "AboutView::version"));
  setFieldName("AboutView::version", i18n("%1 version").arg(aboutData.programName()));
  setFieldContentText("AboutView::version", aboutData.version());

  layout->addWidget(addField(this, "AboutView::about"));
  setFieldName("AboutView::about", i18n("A freeware"));
  setFieldContentURL("AboutView::about", "SETI@home", i18n(SetiURL)
                                       , i18n("Click to visit the SETI@home web site")
                                       , this, SLOT(handleURL(const QString &)));
  setFieldAux("AboutView::about", i18n("client watcher"));

  layout->addWidget(addField(this, "AboutView::copyright"));
  setFieldName("AboutView::copyright", aboutData.copyrightStatement());

  layout->addWidget(addField(this, "AboutView::web"));
  setFieldName("AboutView::web", i18n("Web site:"));
  setFieldContentURL("AboutView::web", i18n(aboutData.homepage()), i18n(aboutData.homepage())
                                     , i18n("Click to visit the KSetiSpy home page")
                                     , this, SLOT(handleURL(const QString &)));

  layout->addWidget(addField(this, "AboutView::email"));
  setFieldName("AboutView::email", i18n("E-mail:"));
  setFieldContentURL("AboutView::email", AuthorEMail, AuthorEMail
                                       , i18n("Click to send email")
                                       , this, SLOT(handleMailTo(const QString &)));

  const QString translators = i18n("Roberto A. Virga");
  if(translators != "Roberto A. Virga")
  {
    layout->addWidget(addField(this, "AboutView::translators"));
    setFieldName("AboutView::translators", i18n("Translation by:"));
    setFieldContentText("AboutView::translators", translators);
  }

  layout->addStretch(1);

  QBoxLayout *hbox = new QBoxLayout(layout, QBoxLayout::RightToLeft);

  KPushButton *helpButton = new KPushButton(i18n("&Help"), this);
  helpButton->installEventFilter(this);
  hbox->addWidget(helpButton);
  connect(helpButton, SIGNAL(clicked()), this, SLOT(handleHelpButton()));

  hbox->addStretch(1);
}

AboutView::~AboutView()
{
}

void AboutView::handleURL(const QString& url)
{
  kapp->invokeBrowser(url);
}

void AboutView::handleMailTo(const QString& recipient)
{
  kapp->invokeMailer(recipient, "KSetiSpy");
}

void AboutView::handleHelpButton()
{
  kapp->invokeHelp();
}

#include "aboutview.moc"

