/***************************************************************************
                             shellfrontend.cpp
                             -------------------
    begin                : Wed Feb 2 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstringlist.h>
#include "shellfrontend.h"

/**
 * Class constructor.
 */
ShellFrontend::ShellFrontend() : Frontend(1)
{
}

/**
 * Class destructor.
 */
ShellFrontend::~ShellFrontend()
{
}

/**
 * Runs the given command inside a shell.
 * KScope is blocked until the execution of the command is over.
 * @param	sCmd		The command to execute
 * @param	sWorkDir	(Optional) working directory
 * @return	The first line of output generated by the command
 */
const QString& ShellFrontend::run(const QString& sCmd, 
	const QString& sWorkDir)
{
	QStringList slArgs;
	
	// Initialise the shell process
	slArgs.append(sCmd);
	m_delim = Newline;
	m_sResult = "";
	setUseShell(true);
	
	// Run the command
	Frontend::run(slArgs, sWorkDir, true);
	return m_sResult;
}

/**
 * Parses the output of the shell command, by simply accepting the first line
 * of output, and discarding everything else.
 * @param	sToken	A line of output generated by the shell command
 * @return	Always DiscardToken (no need for records)
 */
Frontend::ParseResult ShellFrontend::parseStdout(QString& sToken, ParserDelim)
{
	if (m_sResult.isEmpty())
		m_sResult = sToken;
		
	return DiscardToken;
}

#include "shellfrontend.moc"
