/***************************************************************************
                             searchresultsdlg.h
                             -------------------
    begin                : Thu Feb 3 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEARCHRESULTSDLG_H
#define SEARCHRESULTSDLG_H

#include <qregexp.h>
#include "searchresultslayout.h"

/**
 * A dialogue for defining searches on query results.
 * The dialogue is activated from the query results menu.
 * @author Elad Lahav
 */
class SearchResultsDlg : public SearchResultsLayout
{
	Q_OBJECT

public:
	SearchResultsDlg(QWidget* pParent = 0, const char* szName = 0);
	~SearchResultsDlg();

	void setColumn(int);
	int getColumn();
	void getPattern(QRegExp&);
		
protected slots:
	virtual void accept();
	
private:
	/** Possible search types. */
	enum { PlainText = 0, RegExp, SimpRegExp };
	
	/** Remembers the last search type. */
	static int s_nType;
	
	/** Remembers the last value of the Case Sensitive check-box. */
	static bool s_bCaseSensitive;
};

#endif
