/***************************************************************************
                             queryresultsmenu.h
                             -------------------
    begin                : Fri Jan 28 2005
    copyright            : (C) 2005 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QUERYRESULTSMENU_H
#define QUERYRESULTSMENU_H

#include <qpopupmenu.h>
#include <qlistview.h>
#include <qregexp.h>

/**
 * Provides a popup-menu for list views containing query results.
 * The popup menu contains commands for copying field text out of items and
 * for removing items.
 * This class assumes a certain ordering of the list columns. If an owner
 * object uses a different configuration, it needs to call setColumns() after
 * constructing the object.
 * @author Elad Lahav
 */
class QueryResultsMenu : public QPopupMenu
{
	Q_OBJECT
	
public:
    QueryResultsMenu(QWidget* pParent = 0, const char* szName = 0);
    ~QueryResultsMenu();
	
	/** This value should be used with setColumns() to indicate a column
		that does not appear in the owner list. */
	enum { Unused = -2 };
	
	void setColumns(int, int, int, int);
	
public slots:		
	void slotShow(QListViewItem*, const QPoint&, int nCol);
	
signals:
	/** 
	 * Indicates a "Copy [Field]" menu item has been selected. 
	 * @param	pItem	The item for which the menu was displayed
	 * @param	nCol	The requested column
	 */
	void copy(QListViewItem* pItem, int nCol);
	
	/**
	 * Emitted after the user selects search criteria in the "Search Query
	 * Results" dialogue.
	 * @param	pItem	The item for which the menu was displayed
	 * @param	re		The regular expression to search
	 * @param	nCol	The column in which to search
	 */
	void search(QListViewItem* pItem, const QRegExp& re, int nCol);
	
	/**
	 * Indicates the "Show All" menu item has been selected.
	 */
	void showAll();
	
	/** 
	 * Indicates the "Remove Item" menu item has been selected. 
	 * @param	pItem	The item for which the menu was displayed
	 */
	void remove(QListViewItem* pItem);
	
private:
	/** Query field numbers. */
	enum { File = 0, Func, Line, Text };
	
	/** The "Copy File" menu item identifier. */
	int m_nCopyFileId;
	
	/** The "Copy Function" menu item identifier. */
	int m_nCopyFuncId;
	
	/** The "Copy Line" menu item identifier. */
	int m_nCopyLineId;
	
	/** The "Copy Text" menu item identifier. */
	int m_nCopyTextId;
	
	/** The "Search..." menu item identifier. */
	int m_nSearchId;
	
	/** The "Show All" menu item identifier. */
	int m_nShowAllId;
	
	/** The "Remove Item" menu item identifier. */
	int m_nRemItemId;
	
	/** The item for which the popup menu is provided (cannot be NULL). */
	QListViewItem* m_pItem;
	
	/** The query field for which the query was invoked. */
	int m_nField;

	/** Translates query field numbers into column indices. */
	int m_nFieldToCol[4];
		
	void showSearchDlg();
	
private slots:
	void slotActivated(int);
};

#endif
