/***************************************************************************
                          projectfilesdlg.h  -  description
                             -------------------
    begin                : Fri Sep 26 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROJECTFILESDLG_H
#define PROJECTFILESDLG_H

#include <qwidget.h>
#include <projectfileslayout.h>
#include <qdict.h>
#include "projectmanager.h"

class DirScanner;
class ScanProgressDlg;

/**
 * A dialog to manipulate the project's files.
 * The dialog allows the user to add source files to the current project, or
 * remove files from it. The main widget of the dialog is a list view, that
 * displays all files currently in the project. When files are added or
 * removed, this list view is updated. The project, however, is only modified
 * if the user closes the dialog using the "OK" button.
 * Since searches through a list view are very slow, the class also maintains
 * a QDict object, that connects file names with their respective list items.
 * This dictionary is used to ensure duplicated items are not added to the
 * list.
 * @author Elad Lahav
 */

class ProjectFilesDlg : public ProjectFilesLayout, public FileListTarget,
	public FileListSource
{
   Q_OBJECT

public: 
	ProjectFilesDlg(ProjectManager*, QWidget* pParent = 0,
		const char* szName = 0);
	~ProjectFilesDlg();

	virtual void addItem(const QString&);
	virtual bool firstItem(QString&);
	virtual bool nextItem(QString&);

protected:
	virtual void customEvent(QCustomEvent*);

private:
	/** Points to the project manager object created by the KScope class */
	ProjectManager* m_pProjMgr;

	/** Holds all file paths in a quickly searchable format (for duplicate
		entries lookup.) */
	QDict<QListViewItem> m_dicFiles;
	
	/** A thread object to a-synchronously scan directories for source files
		to add to the project */
	DirScanner* m_pScanner;

	/** Displays the progress of a directory scan operation */
	ScanProgressDlg* m_pScanDlg;

	/** A file list item that serves as an iterator */
	QListViewItem* m_pItrItem;

	void removeItem(QListViewItem*);
	
private slots:
	void slotAddFiles();
	void slotAddDir();
	void slotAddTree();
	void slotRemSel();
	void slotRemDir();
	void slotRemTree();
	void slotFilter();
	void slotShowAll();
	void slotCancelDirScan();
};

#endif
