/***************************************************************************
                          openprojectdlg.h  -  description
                             -------------------
    begin                : Wed Jun 11 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPENPROJECTDLG_H
#define OPENPROJECTDLG_H

#include <qwidget.h>
#include <openprojectlayout.h>

/**
 * A dialogue for selecting a project to open.
 * Allows projects to be searched, and displays a list of previosuly loaded
 * projects.
 * @author Elad Lahav
 */

class OpenProjectDlg : public OpenProjectLayout
{
   Q_OBJECT

public: 
	OpenProjectDlg(QWidget* pParent = 0, const char* szName = 0);
	~OpenProjectDlg();

private:
	void loadRecent();

private slots:
	void slotFindProject();
	void slotRemoveProject();
	void slotSelectProject(QListBoxItem*);
	void slotOpenProject(QListBoxItem*);
};

#endif
