/***************************************************************************
                          kscopepixmaps.cpp  -  description
                             -------------------
    begin                : Sat Jul 19 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <kiconloader.h>
#include "kscopepixmaps.h"

static const char* XPM_FUNC[] = {
	"12 12 2 1",
	". c #000000",
	"# c #58a8ff",
	"............",
	".##########.",
	".###....###.",
	".###.######.",
	".###.######.",
	".###.######.",
	".###....###.",
	".###.######.",
	".###.######.",
	".###.######.",
	".##########.",
	"............"
};

static const char* XPM_VAR[] = {
	"12 12 3 1",
	". c #000000",
	"a c #c00000",
	"# c #ff0000",
	"............",
	".##########.",
	".##########.",
	".##.####.##.",
	".##.####.##.",
	".##.a##a.##.",
	".##a.##.a##.",
	".###.aa.###.",
	".###a..a###.",
	".####..####.",
	".##########.",
	"............"
};

static const char* XPM_STRUCT[] = {
	"12 12 2 1",
	". c #000000",
	"# c #ffff00",
	"............",
	".##########.",
	".####...###.",
	".###.###.##.",
	".###.######.",
	".####.#####.",
	".#####.####.",
	".######.###.",
	".##.###.###.",
	".###...####.",
	".##########.",
	"............"
};

static const char* XPM_MACRO[] = {
	"12 12 2 1",
	". c #000000",
	"# c #00c000",
	"............",
	".##########.",
	".##.####.##.",
	".##..##..##.",
	".##.#..#.##.",
	".##.####.##.",
	".##.####.##.",
	".##.####.##.",
	".##.####.##.",
	".##.####.##.",
	".##########.",
	"............"
};

static const char* XPM_MEMBER[] = {
	"12 12 3 1",
	". c #000000",
	"a c #0000c0",
	"# c #c0c0ff",
	"............",
	".##########.",
	".##########.",
	".##########.",
	".##a.##.a##.",
	".##.a..a.##.",
	".##.#aa#.##.",
	".##.####.##.",
	".##.####.##.",
	".##########.",
	".##########.",
	"............"
};

static const char* XPM_ENUM[] = {
	"12 12 2 1",
	". c #000000",
	"# c #ff00ff",
	"............",
	".##########.",
	".##########.",
	".##......##.",
	".##.#######.",
	".##.#######.",
	".##.....###.",
	".##.#######.",
	".##.#######.",
	".##......##.",
	".##########.",
	"............"
};

static const char* XPM_ENUMERATOR[] = {
	"12 12 2 1",
	". c #000000",
	"# c #ffc0c0",
	"............",
	".##########.",
	".##########.",
	".###...####.",
	".##.###.###.",
	".##.###.###.",
	".##.....###.",
	".##.#######.",
	".##.###.###.",
	".###...####.",
	".##########.",
	"............"
};

static const char* XPM_TYPEDEF[] = {
	"12 12 2 1",
	". c #000000",
	"# c #c0ffc0",
	"............",
	".##########.",
	".#.......##.",
	".####.#####.",
	".####.#####.",
	".####.#####.",
	".####.#####.",
	".####.#####.",
	".####.#####.",
	".####.#####.",
	".##########.",
	"............"
};

static const char* XPM_UNKNOWN[] = {
	"12 12 2 1",
	". c #000000",
	"# c #ffffff",
	"............",
	".##########.",
	".##.....###.",
	".#.#####.##.",
	".########.#.",
	".########.#.",
	".#######.##.",
	".######.###.",
	".####.#####.",
	".##########.",
	".####.#####.",
	"............"
};

static const char* XPM_SORTBYNAME_ASC[] = {
	"16 16 4 1",
	". c None",
	"b c #000000",
	"# c #000080",
	"a c #0000ff",
	"................",
	".....##aaaaa..b.",
	"....###aaaaaa.b.",
	"....###aa..aa.b.",
	"...####aa..aa.b.",
	"...####aa..aa.b.",
	"..##.##aaaaaa.b.",
	"..##.##aaaaa..b.",
	".##..##aaaaaa.b.",
	".######aa..aa.b.",
	"#######aa..aa.b.",
	"##...##aa..aa.b.",
	"##...##aa..aa.b.",
	"##...##aaaaaabbb",
	"##...##aaaaa..b.",
	"................"
};

static const char* XPM_SORTBYNAME_DES[] = {
	"16 16 4 1",
	". c None",
	"b c #000000",
	"# c #000080",
	"a c #0000ff",
	"................",
	".....##aaaaa..b.",
	"....###aaaaaabbb",
	"....###aa..aa.b.",
	"...####aa..aa.b.",
	"...####aa..aa.b.",
	"..##.##aaaaaa.b.",
	"..##.##aaaaa..b.",
	".##..##aaaaaa.b.",
	".######aa..aa.b.",
	"#######aa..aa.b.",
	"##...##aa..aa.b.",
	"##...##aa..aa.b.",
	"##...##aaaaaa.b.",
	"##...##aaaaa..b.",
	"................"
};

static const char* XPM_SORTBYLINE_ASC[] = {
	"16 16 3 1",
	". c None",
	"a c #000000",
	"# c #000080",
	"................",
	".###########..a.",
	"..............a.",
	".#########....a.",
	"..............a.",
	".#########....a.",
	"..............a.",
	".#####........a.",
	"..............a.",
	".##...........a.",
	"..............a.",
	".#####........a.",
	"..............a.",
	".##########..aaa",
	"..............a.",
	"................"
};

static const char* XPM_SORTBYLINE_DES[] = {
	"16 16 3 1",
	". c None",
	"a c #000000",
	"# c #000080",
	"................",
	".###########..a.",
	".............aaa",
	".#########....a.",
	"..............a.",
	".#########....a.",
	"..............a.",
	".#####........a.",
	"..............a.",
	".##...........a.",
	"..............a.",
	".#####........a.",
	"..............a.",
	".##########...a.",
	"..............a.",
	"................"
};

/**
 * Class constructor.
 */
KScopePixmaps::KScopePixmaps() :
	m_pPixArray(NULL),
	m_loader()
{
}

/**
 * Class destructor.
 */
KScopePixmaps::~KScopePixmaps()
{
	delete [] m_pPixArray;
}

/**
 * Creates the array of embedded pixmaps.
 * This function is separated from the constructor since QPixmap objects 
 * cannot be created at the time the static KScopePixmaps object is 
 * allocated.
 */
void KScopePixmaps::init()
{
	// Create the pixmap array
	m_pPixArray = new QPixmap*[PIX_ARRAY_SIZE];

	// Create all pixmaps
	m_pPixArray[SymFunc] = new QPixmap(XPM_FUNC);
	m_pPixArray[SymVar] = new QPixmap(XPM_VAR);
	m_pPixArray[SymStruct] = new QPixmap(XPM_STRUCT);
	m_pPixArray[SymMacro] = new QPixmap(XPM_MACRO);
	m_pPixArray[SymMember] = new QPixmap(XPM_MEMBER);
	m_pPixArray[SymEnum] = new QPixmap(XPM_ENUM);
	m_pPixArray[SymEnumerator] = new QPixmap(XPM_ENUMERATOR);
	m_pPixArray[SymTypedef] = new QPixmap(XPM_TYPEDEF);
	m_pPixArray[SymUnknown] = new QPixmap(XPM_UNKNOWN);
	m_pPixArray[SortByNameAsc] = new QPixmap(XPM_SORTBYNAME_ASC);
	m_pPixArray[SortByNameDes] = new QPixmap(XPM_SORTBYNAME_DES);
	m_pPixArray[SortByLineAsc] = new QPixmap(XPM_SORTBYLINE_ASC);
	m_pPixArray[SortByLineDes] = new QPixmap(XPM_SORTBYLINE_DES);
}

/**
 * Returns a reference to an embedded pixmap.
 * @param	name	The pixmap's identifier
 * @return	A reference to the requested pixmap
 */
const QPixmap& KScopePixmaps::getPixmap(PixName name) const
{
	return *m_pPixArray[name];
}

/**
 * Loads a pixmap with the KIconLoader mechanism.
 * @param	name	The pixmap's identifier
 * @return	The requested pixmap
 */
QPixmap KScopePixmaps::getPixmap(LoadPixName name)
{
	switch (name) {
	case ToolbarReload:
		return m_loader.loadIcon("reload_page", KIcon::Toolbar,
			0, false);
	
	case GoBack:
		return m_loader.loadIcon("back", KIcon::Toolbar, 0,
			false);
	
	case GoForward:
		return m_loader.loadIcon("forward", KIcon::Toolbar, 0,
			false);
		
	case ButtonNewQuery:
		return m_loader.loadIcon("filenew", KIcon::Toolbar, 
			0, false);
		
	case ButtonLockQuery:
		return m_loader.loadIcon("encrypted", KIcon::Toolbar, 
			0, false);
		
	case ButtonUnlockQuery:
		return m_loader.loadIcon("decrypted", KIcon::Toolbar, 
			0, false);
		
	case ButtonRefreshQuery:
		return m_loader.loadIcon("reload", KIcon::Toolbar, 
			0, false);
		
	case ButtonCloseQuery:
		return m_loader.loadIcon("fileclose", KIcon::Toolbar, 
			0, false);

	case TabUnlocked:
		return m_loader.loadIcon("query_unlocked", KIcon::Small, 0,
			false);

	case TabLocked:
		return m_loader.loadIcon("query_locked", KIcon::Small, 0,
			false);

	case TabRW:
		return m_loader.loadIcon("file_rw", KIcon::Small, 0,
			false);

	case TabRO:
		return m_loader.loadIcon("file_ro", KIcon::Small, 0,
			false);

	case TabSave:
		return m_loader.loadIcon("file_save", KIcon::Small, 0,
			false);
	
	case TabFileList:
		return m_loader.loadIcon("view_detailed", KIcon::Small, 0,
			false);

	case TabFileTree:
		return m_loader.loadIcon("view_tree", KIcon::Small, 0,
			false);
			
	case TabList:
		return m_loader.loadIcon("tab_list", KIcon::Small, 0,
			false);
	}

	return QPixmap();
}

/**
 * @return	A reference to a global KScopePixmaps object
 */
KScopePixmaps& Pixmaps()
{
	static KScopePixmaps pix;
	return pix;
}
