/***************************************************************************
                          kscope.h  -  description
                             -------------------
    begin                : Fri May  9 09:16:06 IDT 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCOPE_H
#define KSCOPE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtimer.h>
#include <kcmdlineargs.h>
#include <kapp.h>
#include <kparts/dockmainwindow.h>
#include <kparts/part.h>
#include <kprogress.h>

class ProjectManager;
class EditorTabs;
class FileView;
class FileList;
class QueryWidget;
class EditorManager;
class CscopeFrontend;
class EditorPage;
class ProgressDlg;
class CscopeMsgDlg;
class CallTreeManager;

/**
 * Defines the main window of KScope.
 * The main window has both UI and functional tasks. As a window, it is
 * composed of three parts:
 * 1. The editing area (EditorTabs - a tab widget with editor pages)
 * 2. The project pane (FileList - listing the files in the project)
 * 3. The query pane (QueryWidget - a tab widget with pages displaying query
 *    results in lists)
 * The main window also maintains the main menu, the toolbar and the status-
 * bar, and is responsible for handling all the actions connected to these
 * bars.
 * As the application's main class, it is responsible for managing projects
 * (using a ProjectManager object) and for running instances of Cscope
 * (through a CscopeFrontend object).
 * @author Elad Lahav
 */
class KScope : public KParts::DockMainWindow
{
	Q_OBJECT

public:
	KScope(QWidget* pParent = 0, const char* szName = 0);
	~KScope();

	void openProject(const QString&);
	bool openCscopeOut(const QString&);
	void parseCmdLine(KCmdLineArgs *pArgs);
		
public slots:
	void slotClose();

protected:
	virtual bool queryClose();
	
private:
	/** A project manager used to load projects and read their properties. */
	ProjectManager* m_pProjMgr;
	
	/** The editors tabbed window. */
	EditorTabs* m_pEditTabs;
	
	/** The file selection widget (project file list and OS file system
		tree.) */
	FileView* m_pFileView;
	
	/** Pointer to the file list part of the FileView widget. */
	FileList* m_pFileList;
	
	/** The query results tabbed window. */
	QueryWidget* m_pQueryWidget;
	
	/** A KDE editor part manager, responsible for creating KTextEditor
		parts. */
	EditorManager* m_pEditMgr;
	
	/** A Cscope process for building the database. */
	CscopeFrontend* m_pCscopeBuild;

	/** A timer for rebuilding the database after a file has been saved. */
	QTimer m_timerRebuild;
	
	/** Whether the query window should be hidden after the user selects an
		item. */	
	bool m_bHideQueryOnSelection;
	
	/** The file view docking area. */
	KDockWidget* m_pFileViewDock;
	
	/** The query window docking area. */
	KDockWidget* m_pQueryDock;

	/** A persistent dialog used to display error messages from Cscope. */
	CscopeMsgDlg* m_pMsgDlg;
	
	/** The path of the file currently being edited. */
	QString m_sCurFilePath;
	
	/** The line number of the current cursor position. */
	int m_nCurLine;

	/** The "Edit in External Editor" menu command. */
	KAction* m_pExtEditAction;
	
	/** Creates and maintains call tree dialogues. */
	CallTreeManager* m_pCallTreeMgr;
	
	/** A progress dialogue that is displayed when building the database for
		the first time. */
	KProgressDialog* m_pProgressDlg;
	
	/** A flag indicating whether the GUI of the embedded editor should be
		merged with that of KScope's. Can be turned off to save time when
		loading/closing a number of editor parts. */
	bool m_bUpdateGUI;
	
	void initActions();
	void initMainWindow();
	void initCscope();
	bool getSymbol(uint&, QString&, bool bPrompt = true);
	EditorPage* addEditor(const QString&s);
	EditorPage* createEditorPage();
	inline bool isAutoRebuildEnabled();
	void loadOpenFiles();
	
private slots:
	// Menu actions
	void slotNewFile();
	void slotOpenFile();
	void slotCloseEditor();
	void slotCreateProject();
	void slotOpenProject();
	void slotProjectFiles();
	void slotProjectProps();
	void slotProjectCscopeOut();
	bool slotCloseProject();
	void slotQueryReference();
	void slotQueryDefinition();
	void slotQueryCalled();
	void slotQueryCalling();
	void slotQueryText();
	void slotQueryPattern();
	void slotQueryFile();
	void slotQueryIncluding();
	void slotQueryQuickDef();
	void slotCallTree();
	void slotRebuildDB();
	void slotCloseQuery();
	void slotHistoryShow();
	void slotShortcuts();
	void slotConfigure();
	void slotCloseAllWindows();
	void slotToggleFileListDock();
	void slotToggleQueryDock();
	void slotToggleQueryButtons();
	void slotExtEdit();
	void slotCompleteSymbol();
	
	// Other slots
	void slotProjectFilesChanged();
	void slotFilesAdded(const QStringList&);
	void slotQuery(uint, bool);
	void slotDeleteEditor(EditorPage*);
	void slotChangeEditor(EditorPage*, EditorPage*);
	void slotShowEditor(const QString&, uint);
	void slotFileOpened(EditorPage*, const QString&);
	void slotSetRebuildTimer(const QString&);
	void slotCscopeError(const QString&);
	void slotBuildProgress(int, int);
	void slotBuildFinished(uint);
	void slotApplyPref();
	void slotShowQueryWindow();
	void slotShowCursorPos(uint, uint);
	void slotQueryShowEditor(const QString&, uint);
	void slotProjectRootChanged(const QString&);
	void slotDropEvent(QDropEvent*);
};

#endif
