/***************************************************************************
                          historypage.h  -  description
                             -------------------
    begin                : Wed Dec 15 2004
    copyright            : (C) 2004 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HISTORYPAGE_H
#define HISTORYPAGE_H

#include <querypage.h>

/**
 * A query-like page for holding position history.
 * Position history is kept in a stack-like list. Positions are always added
 * to the top of the list, immediately before the current item. If the
 * current item is not the top one, all items above it are purged first.
 * To keep the stack-like structure, the list cannot be sorted.
 * @author Elad Lahav
 */
class HistoryPage : public QueryPage
{
	Q_OBJECT

public:
	HistoryPage(QWidget* pParent = 0, const char* szName = 0);
	~HistoryPage();
	
	void addRecord(const QString&, uint, const QString&);
	void selectNext();
	void selectPrev();
	
	virtual QString getCaption(bool bBrief = false) const;

protected:
	virtual void addRecord(const QString&, const QString&, const QString&,
		const QString&);
	virtual QString getFileName(const QString&) const;
	
	/**
	 * @return	Always true, since History files do not contain a header
	 */
	virtual bool readHeader(QTextStream&) { return true; }
	
	/**
	 * This method does nothing, since History files do not contain a header.
	 */	
	virtual void writeHeader(QTextStream&) {}

protected slots:
	virtual void slotRemoveItem(QListViewItem*);

private:
	/** A unique ID used to create a tab caption for this page. */
	int m_nPageID;

	/** Used to generate the unique page ID for each object. */
	static int s_nMaxPageID;
};

#endif
