/***************************************************************************
                          fileview.h  -  description
                             -------------------
    begin                : Mon Sep 27 2004
    copyright            : (C) 2004 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEVIEW_H
#define FILEVIEW_H

#include <kfiletreeview.h>
#include "fileviewlayout.h"

/**
 * A tabbed widget that contains a file list and a file tree.
 * The list is an object of type FileList, which displays all files included
 * in the current project. The tree is a standard KFileTreeView, which can
 * browse through the entire file system. Optionally, the root of the tree
 * can be set per project.
 * @author Elad Lahav
 */

class FileView : public FileViewLayout
{
	Q_OBJECT

public:
	FileView(QWidget* pParent = 0, const char* szName = 0, WFlags fl = 0);
	~FileView();

	/**
	 * @return	The file list widget which is a child of this widget.
	 */
	FileList* getFileList() { return m_pFileList; }
	
	void setTreeRoot(const QString&);
	void clear();
	
signals:
	/**
	 * Emitted when a file is selected, by either double-clicking a list
	 * item, or by highlighting an item and pressing the ENTER key.
	 * @param	sPath	The full path of the selected file
	 * @param	nLine	Line number, always set to 0
	 */
	void fileRequested(const QString& sPath, uint nLine);
	
	/**
	 * Emitted when a new root directory is set for the file tree.
	 * @param	sPath	The full path of the new root directory
	 */
	void rootChanged(const QString& sPath);
	
	/**
	 * Emitted when the "Find..." button of the widget is clicked.
	 */
	void findFile();

private:
	/** The current branch in the file tree. */
	KFileTreeBranch* m_pCurBranch;

private slots:
	void slotChangeRoot();
	void slotTreeItemSelected(QListViewItem*);
};

#endif

