/***************************************************************************
                          editortabs.h  -  description
                             -------------------
    begin                : Fri May 9 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITORTABS_H
#define EDITORTABS_H

#include <qwidget.h>
#include <qpopupmenu.h>
#include "tabwidget.h"
#include "editorpage.h"

typedef QMap<QString, EditorPage*> EditorMap;

/**
 * A tab widget that holds several editor windows.
 * This class provides the main widget in the KScope window. All editors are
 * opened as pages of the tab widgets.
 * @author Elad Lahav
 */

class EditorTabs : public TabWidget
{
   Q_OBJECT
   
public:
	EditorTabs(QWidget* pParent = 0, const char* szName = 0);
	~EditorTabs();

	void setWindowMenu(QPopupMenu*);
	void addEditorPage(EditorPage*);
	EditorPage* findEditorPage(const QString&);
	EditorPage* getCurrentPage();
	void removeCurrentPage();
	bool removeAllPages();
	void applyPrefs();
	void getOpenFiles(QStringList&);
	
public slots:
	void slotRemovePage(QWidget*);
	void slotToggleTagList();
	
signals:
	/**
	 * Emitted when the current editor page changes.
	 * @param	pOld	The previous current page
	 * @param	pNew	The new current page
	 */
	void editorChanged(EditorPage* pOld, EditorPage* pNew);
	
	/**
	 * Emitted when an editor page is closed.
	 * @param	pPage	The removed page
	 */
	void editorRemoved(EditorPage* pPage);
	
	void filesDropped(QDropEvent*);
	
protected:
	virtual void dragMoveEvent(QDragMoveEvent*);
	virtual void dropEvent(QDropEvent*);
	
private:
	/** Links a file name with an editor page that has this file open. */
	EditorMap m_mapEdit;

	/** We need to keep track of the current page in order to implement the
		editorChanged() signal. */
	EditorPage* m_pCurPage;
	
	/** A popup menu with Cscope operations for the editor windows. */
	QPopupMenu* m_pWindowMenu;
	
	/** A counter for creating unique tab captions for new files. */
	int m_nNewFiles;
	
	int getModifiedFilesCount();
	void saveAllFiles();
	bool removePage(QWidget*, bool);
		
private slots:
	void slotCurrentChanged(QWidget*);
	void slotAttachFile(EditorPage*, const QString&);
	void slotNewFile(EditorPage*);
	void slotFileModified(EditorPage*, bool);
	void slotInitiateDrag(QWidget*);
};

#endif
