/***************************************************************************
                          editormanager.cpp  -  description
                             -------------------
    begin                : Sun May 18 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ktexteditor/editorchooser.h>
#include <kate/document.h>
#include "editormanager.h"
#include "kscopeconfig.h"

/**
 * Class constructor.
 * @param	pParent	The parent widget
 * @param	szName	The widget's name
 */
EditorManager::EditorManager(QWidget* pParent, const char* szName) :
	KParts::PartManager(pParent, szName)
{
	applyPrefs();
}

/**
 * Class destructor.
 */
EditorManager::~EditorManager()
{
}

/**
 * Creates a new document part.
 * @return	A pointer to the new document
 */
KTextEditor::Document* EditorManager::add()
{
	KTextEditor::Document* pDoc;
	
	// Create the document
	pDoc = KTextEditor::EditorChooser::createDocument(this);
	addPart(pDoc);

	return pDoc;
}

/**
 * Deletes a document part.
 * @param	pDoc	The document to remove
 */
void EditorManager::remove(KTextEditor::Document* pDoc)
{
	removePart(pDoc);
	delete pDoc;
}

/**
 * Applies the user preferences.
 * Determines if Kate warnings are displayed in case the currently edited
 * file is modified outside KScope.
 * NOTE: This behaviour is determined by a static function, which is why this
 * code appears here, rather then for every EditorPage object.
 */
void EditorManager::applyPrefs()
{
	Kate::Document::setFileChangedDialogsActivated(
		Config().getWarnModifiedOnDisk());
}
