/***************************************************************************
                             calltreemanager.cpp
                             -------------------
    begin                : Mon Jan 17 2005
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "calltreemanager.h"
#include "calltreedlg.h"
#include "projectmanager.h"

/**
 * Class constructor.
 * @param	pParent	The widget to use as the parent of all Call Tree dialogues
 */
CallTreeManager::CallTreeManager(QWidget* pParent) : QObject(pParent)
{
}

/**
 * Class destructor.
 */
CallTreeManager::~CallTreeManager()
{
	closeAll();
}

/** 
 * Saves all call trees into the project directory 
 */
void CallTreeManager::saveOpenDialogs(const QString& sProjPath,
	QStringList& slCallTreeFiles)
{
	CallTreeDlg *pTree;
	
	for (pTree = m_pCallTreeList.first(); pTree != NULL; 
		pTree = m_pCallTreeList.next() ) {
		pTree->store(sProjPath);
		slCallTreeFiles += pTree->getFileName();
	}
}

/** 
 * Loads all call trees according to the list of files 
 */
void CallTreeManager::loadOpenDialogs(const QString& sProjPath,
	QStringList& slCallTreeFiles)
{
	QStringList::Iterator itr;
	CallTreeDlg *pTree;
	
	for (itr = slCallTreeFiles.begin(); 
		itr != slCallTreeFiles.end(); ++itr) {
		pTree = addDialog(QString::null);
		if (pTree) {
			pTree->hide();
			if (!pTree->load(sProjPath, *itr)) {
				delete pTree;
				continue;
			}
			pTree->show();
		}
	}
}

/** 
 * Creates a new Call Tree dialogue.
 * @param	sFunc	The function to become the root of the tree 
 */
CallTreeDlg* CallTreeManager::addDialog(const QString& sFunc) 
{
	CallTreeDlg* pTree;
	
	// Create a modeless call tree dialogue
	pTree = new CallTreeDlg(sFunc, (QWidget*)parent());
	m_pCallTreeList.append(pTree); 
	
	// Open an editor whenever a function name is double-clicked
	connect(pTree, SIGNAL(lineRequested(const QString&, uint)),
		this, SIGNAL(lineRequested(const QString&, uint)));

	// Track the closing of the call tree dialog
	connect(pTree, SIGNAL(closed(const CallTreeDlg*)), this,
		SLOT(slotRemoveDialog(const CallTreeDlg*)));
	
	return pTree;
}
/** 
 * Close all Call Tree dialogs 
 */
void CallTreeManager::closeAll()
{
	CallTreeDlg *pTree;
	
	for (pTree = m_pCallTreeList.first(); pTree != NULL; 
		pTree = m_pCallTreeList.first() ) {
		delete pTree;
	}
}

