/***************************************************************************
                          calltreedlg.h  -  description
                             -------------------
    begin                : Fri Jul 18 2003
    copyright            : (C) 2003 by Elad Lahav
    email                : elad_lahav@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CALLTREEDLG_H
#define CALLTREEDLG_H

#include <qwidget.h>
#include <qlistview.h>
#include <calltreelayout.h>
#include "cscopefrontend.h"

class QueryResultsMenu;

/**
 * Displays a hierarchical tree of calling/called functions.
 * Each item in the tree is composed of the function name, the path of the
 * source file in which it is defined, the line number and the full text of
 * that line.
 * @author Elad Lahav
 */

class CallTreeDlg : public CallTreeLayout
{
   Q_OBJECT
   
public: 
	CallTreeDlg(const QString& sFunc, QWidget* pParent = 0, 
		const char* szName = 0);
	~CallTreeDlg();
	
	/** Loads Call Tree from the specified path and filename */
	bool load(const QString&, const QString&);
	
	/** Saves Call Tree to the specified path */
	void store(const QString&);
	
	/** Returns Call Tree filename */
	QString getFileName() {return m_sFileName;}

signals:
	/**
	 * Emitted when the user selects an item in the tree view.
	 * @param	sPath	The full path of the file associated with the item
	 * @param	nLine	The line number associated with the item
	 */
	void lineRequested(const QString& sPath, uint nLine);
	
	/**
	 * Emitted when the user closes the tree view.
	 */
	void closed(const CallTreeDlg*);
	
private:
	/** A Cscope process to use for running queries. */
	CscopeFrontend* m_pCscope;
	
	/** The tree item last expended (i.e., for which call tree was
		requested.) */
	QListViewItem* m_pActiveItem;
	
	/** Displays query progress information. */
	CscopeProgress m_progress;

	/** The save places for calling/called trees when switched from
		one to another */
	QListView *m_pCallingTreeSave;
	QListView *m_pCalledTreeSave;
	
	/** The tree item last expended (i.e., for which calling functions were
		requested.) */
	QListViewItem* m_pActiveCallingItem;
	
	/** The tree item last expended (i.e., for which called functions were
		requested.) */
	QListViewItem* m_pActiveCalledItem;
	
	/** File name to save the call tree */
	QString m_sFileName;
	
	/** A popup-menu for manipulating query result items. */
	QueryResultsMenu* m_pQueryMenu;
		
	/** File Name index for the file name generation */
	static int m_iFileNameIndex;
	
	void queryCallTree(const QString&);
	void saveSubTreeToStream(bool, QTextStream&);
	

private slots:
	void slotExpandFunc(QListViewItem*);
	void slotRequestLine(QListViewItem*);
	void slotDataReady(FrontendToken*);
	void slotProgress(int, int);
	void slotFinished(uint);
	void slotCallTreeModeChanged(bool);
	void slotCopy(QListViewItem*, int);
	void slotSearch(QListViewItem*, const QRegExp&, int);
	void slotShowAll();
	void slotRemoveItem(QListViewItem*);
};

#endif
