/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdcategorymenu.h"
#include "kkdcategoryitem.h"

#include <klocale.h>

using namespace KKDSubscribeTemplate;

KKDCategoryMenu::KKDCategoryMenu( QWidget* parent, const char* name )
	: QPopupMenu( parent, name ), m_id( -1 )
{
	connect( this, SIGNAL( activated( int ) ), this, SLOT( slotActivated( int ) ) );
}

KKDCategoryMenu::~KKDCategoryMenu()
{
}

void KKDCategoryMenu::setItem( KKDCategoryItem* item )
{
	if( m_id != -1 )
	{
		insertItem( i18n( "This Category" ) );
		insertSeparator();
	}
	for( KKDCategoryItem* child = item->list().first(); child; child = item->list().next() )
	{
		if( child->list().count() == 0 )
		{
			m_strPaths[insertItem( child->title() )] = child->path();
		}
		else
		{
			KKDCategoryMenu* submenu = new KKDCategoryMenu( this );
			int id = insertItem( child->title(), submenu );
			submenu->setID( id );
			m_strPaths[id] = child->path();
			submenu->setItem( child );
			connect( submenu, SIGNAL( decided( int, const QString&, const QString& ) ), this, SLOT( slotDecided( int, const QString&, const QString& ) ) );
		}
	}
}

void KKDCategoryMenu::slotActivated( int i )
{
	if( m_id != -1 && i == idAt( 0 ) )
	{
		emit decided( m_id, "", "" );
	}
	else
	{
		emit decided( m_id, text( i ) + "/", m_strPaths[i] + "/" );
	}
}

void KKDCategoryMenu::slotDecided( int id, const QString& str, const QString& path )
{
	emit decided( m_id, text( id ) + "/" + str, m_strPaths[id] + "/" + path );
}
