/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kdebug.h>

#include "kkdsizehandler.h"
#include "kkdsizehandlerwidget.h"
#include "kkditembase.h"

using namespace KKDesigner;

KKDSizeHandler::KKDSizeHandler( QWidget* parent, KKDItemBase* item )
	: QObject( parent )
{
	m_item = item;
	connect( m_item, SIGNAL( locationChanged() ), this, SLOT( setGeometry() ) );
	connect( m_item, SIGNAL( sizeChanged() ), this, SLOT( setGeometry() ) );

	for( int y = 2; y != -1 ; y-- )
	{
		for( int x = 2; x != -1; x-- )
		{
			if( y == 1 && x == 1 ) continue;
			KKDSizeHandlerWidget* w = new KKDSizeHandlerWidget( x, y, parent );
			w->hide();
			connect( w, SIGNAL( moving( int, int, QPoint ) ), this, SLOT( resize( int, int, QPoint ) ) );
			connect( w, SIGNAL( start() ), this, SIGNAL( start() ) );
			connect( w, SIGNAL( moving( int, int, QPoint ) ), this, SIGNAL( resizing() ) );
			connect( w, SIGNAL( end() ), this, SIGNAL( end() ) );
			m_sh[y][x] = w;
		}
	}
	setGeometry();
}

KKDSizeHandler::~KKDSizeHandler()
{
	for( int y = 2; y != -1 ; y-- )
	{
		for( int x = 2; x != -1; x-- )
		{
			if( y == 1 && x == 1 ) continue;
			delete m_sh[y][x];
		}
	}
}

void KKDSizeHandler::setVisible()
{
	for( int y = 0; y != 3; y++ )
	{
		for( int x = 0; x != 3; x++ )
		{
			if( y == 1 && x == 1 ) continue;
			if( m_item->selected() )
			{
				m_sh[y][x]->show();
			}
			else
			{
				m_sh[y][x]->hide();
			}
		}
	}
}

void KKDSizeHandler::setGeometry()
{
	for( int y = 0; y != 3; y++ )
	{
		for( int x = 0; x != 3; x++ )
		{
			if( y == 1 && x == 1 ) continue;
			m_sh[y][x]->move( m_item->location().x() + ( m_item->size().width() ) * x/2 - 2 - x / 2, m_item->location().y() + ( m_item->size().height() ) * y/2 - 2 - y / 2 );
		}
	}
}

void KKDSizeHandler::resize( int x, int y, int w, int h, int ax, int ay )
{
	if( w < 0 )
	{
		if( ax == 0 )
		{
			x = m_item->location().x() + m_item->size().width();
		}
		else if( ax == 2 )
		{
			x = m_item->location().x();
		}
		w = 0;
	}
	if( h < 0 )
	{
		if( ay == 0 )
		{
			y = m_item->location().y() + m_item->size().height();
		}
		else if( ay == 2 )
		{
			y = m_item->location().y();
		}
		h = 0;
	}
	m_item->setLocation( x, y );
	m_item->setSize( w, h );
}

void KKDSizeHandler::resize( int x, int y, QPoint p )
{
	resize(
		m_item->location().x() + p.x() * ( x == 0 ? 1 : 0 ),
		m_item->location().y() + p.y() * ( y == 0 ? 1 : 0 ),
		m_item->size().width() - p.x() * ( 1 - x ),
		m_item->size().height() - p.y() * ( 1 - y ),
		x,
		y
	);
}
