/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef STREAMDIRECTORYPROXYMODEL_H
#define STREAMDIRECTORYPROXYMODEL_H

#include <QSortFilterProxyModel>
#include "streamdirectorymodel.h"

/** \brief An proxy model for #streamDirectoryModel
*
* This class provides a proxy model for #streamDirectoryModel or inherited classes.
* It is a class that extends \e QSortFilterProxyModel with the ability to handle correctly the
* #hasChildren() function and provides case insensitive sorting by default. */
class streamDirectoryProxyModel : public QSortFilterProxyModel
{
  public:
    /** The constructor.
    * @param parent Set's the parent. It's at the same time the source model.
    * \note After the construction of the object, the source model can't be changed anymore. */
    explicit streamDirectoryProxyModel(streamDirectoryModel *parent);
    /** The destructor. */
    virtual ~streamDirectoryProxyModel();
    /** Reimplemented from base class to provide this functionality. */
    virtual bool hasChildren(const QModelIndex & parent) const;
    /** A dummy function without any functionality. Use the constructor to pass the source model.
    * Once set, it can't be changed anymore. */
    virtual void setSourceModel(QAbstractItemModel *sourceModel);
};

#endif
