#!/bin/sh
# Generate a release-ready tarball
# Expects the version number as argument.
# If second argument is stable, than a stable release is produced, else an unstable release.
SCRIPTDIR=`pwd`


cd ${SCRIPTDIR}
./set-version.sh $1 $2 # must be _before_ generating apidoc because it changes doxygen file
cd ${SCRIPTDIR}
./extract-messages.sh
cd ${SCRIPTDIR}
./remove-old-apidoc.sh
cd ${SCRIPTDIR}
./make-apidoc.sh
cd ${SCRIPTDIR}
./remove-build-files.sh # This is done before compiling to make sure to make a build from zero, like the user will do.
cd ${SCRIPTDIR}
./cmake.sh
cd ${SCRIPTDIR}
./generate-manpage.sh
cd ${SCRIPTDIR}
./remove-build-files.sh # Delete build files again.
cd ${SCRIPTDIR}
./codecheck.sh
cd ${SCRIPTDIR}
if [ "$2" = "stable" ]; # if second parameter is "stable"...
then ./create-archive.sh "kradioripper-$1";
else ./create-archive.sh "kradioripper-unstable-$1.unstable";
fi
