# - Try to find libproxy
# Once done this will define
#
#  LIBPROXY_FOUND - system has libproxy
#  LIBPROXY_INCLUDE_DIR - the libproxy include directory
#  LIBPROXY_LIBRARIES - libproxy library
#
# Copyright (c) 2009, Lukas Sommer
#
# This file is released to the public domain.

INCLUDE(CheckLibraryExists)

FIND_PATH(LIBPROXY_INCLUDE_DIR proxy.h )

FIND_LIBRARY(LIBPROXY_LIBRARIES NAMES libproxy libproxy.so libproxy.so.0 libproxy.so.0.0 libproxy.so.0.0.0 )

IF (LIBPROXY_INCLUDE_DIR AND LIBPROXY_LIBRARIES)
   SET(LIBPROXY_FOUND TRUE)
   IF (NOT libproxy_FIND_QUIETLY)
      MESSAGE(STATUS "Found libproxy: ${LIBPROXY_LIBRARIES}")
   ENDIF (NOT libproxy_FIND_QUIETLY)
ELSE  (LIBPROXY_INCLUDE_DIR AND LIBPROXY_LIBRARIES)
   SET(LIBPROXY_FOUND FALSE)
   # clear variables (who have the value "<NAME>-NOTFOUND")
   SET(LIBPROXY_LIBRARIES)
   SET(LIBPROXY_INCLUDE_DIR)
   IF (libproxy_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could NOT find libproxy")
   ENDIF (libproxy_FIND_REQUIRED)
ENDIF (LIBPROXY_INCLUDE_DIR AND LIBPROXY_LIBRARIES)
