/***************************************************************************
                          mainview.cpp  -  description
                             -------------------
    begin                : Mon Jul 3 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mainview.h"
#include <stdlib.h>
#include <stdio.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qaccel.h>
#include <qsplitter.h>
#include <qlayout.h>
#include <qvaluelist.h>
#include <qstring.h>
#include <kseparator.h>

#include "globals.h"
#include "fixtext.h"
#include "logbook.h"
#include "waterfall.h"


logBook* logbook;
waterfall* water;

mainView::mainView(QWidget *parent) : QWidget(parent)
{
	KSeparator* sep1=NULL;
  /*
	 * Here we constructs our main Widget. We have an apnner
   * for the TX/RX Windows, and an 'control' widget
	 */

	QVBoxLayout* box = new QVBoxLayout (this);
	box->setSpacing (2);
	
	fixtext = new fixText (this);
	logbook = new logBook (this);
	sep1 = new KSeparator (this);

	splitter = new QSplitter (QSplitter::Vertical, this);
	rxwindow = new GTTextWidget (splitter);
  rxwindow->setFont (config.screen.rxwinfont);
  rxwindow->setPaletteBackgroundColor(config.bkground.rxb);              
	rxwindow->setColors (config.rxwincolor.rx, config.rxwincolor.tx);
  rxwindow->setMinimumHeight(20);
  QObject::connect (rxwindow, SIGNAL (newCallsign (QString)), logbook, SLOT (slotSetCall(QString)));


	txwindow = new GTTextWidget (splitter);
  txwindow->setFont (config.screen.txwinfont);
  txwindow->setPaletteBackgroundColor(config.bkground.txb);            
  txwindow->setEditEnabled (true);
  txwindow->setFocus();
  txwindow->setMinimumHeight(20);
	QObject::connect (txwindow, SIGNAL (textAppended (char*)), this, SLOT(slotTransmitText(char*)));

	water = new waterfall(splitter);

	box->addSpacing (3);
	box->addWidget (logbook);
	box->addSpacing (3);
	box->addWidget (sep1);
	box->addSpacing (1);

	box->addWidget (fixtext);
	box->addSpacing (1);
	box->addWidget (splitter);

/* Timer for the receiver */
	QTimer* timer = new QTimer(this);
	QObject::connect( timer, SIGNAL(timeout()), SLOT(slotRX()));
  timer->start (50, false);

	QObject::connect (logbook->bandEdit, SIGNAL (activated(int)), water, SLOT (slotNewBand (int)));
}
mainView::~mainView()
{
}

void mainView::slotRX()
{
	char rxbuf[10];
	char txbuf[10];
	int l;

  /* Handle echo, if we are on the main channel */
		l = commGetData(COMM_ECHOCH, txbuf, sizeof txbuf);
  		if(l > 0) {
			txbuf [l] = 0;
			
      rxwindow->appendString(txbuf,true,true );
	  }

   /*
    * handle receive!
    */
   l = commGetData(COMM_RXCH, rxbuf, sizeof rxbuf);
   if(l > 0)
   {
		rxbuf[l] = 0;
		
    rxwindow->appendString(rxbuf, true, false);

   }
}
/** Slot for simple transmission, without interpretation of TX/RX codes */
void mainView::slotTransmitText (char* text)
{
	commPutData (text, strlen(text));
}

/** Transmit a text - with 0x00 / 0x01 TX/RX switching
 */
void mainView::transmitText (QString str)
{
	if (str.isNull() == true) return;
	else {
		QString tmpstr;
  	unsigned int i = 0;
		int pos;
		char *c = strdup (str.latin1());
		char buf[9999];

		str.replace (QRegExp ("\001"), "");   /* TX */
		str.replace (QRegExp ("\002"), "");   /* RX */


    txwindow->appendString(str, false);
		pos=0;
		i=0;
		for (;;) {
			buf[pos] = c[i];
			if (c[i] == 0) {
				if (pos != 0) commPutData (buf, pos);
				break;
			}
			if (c[i] == 1 || c[i] == 2) {
				if (pos != 0) commPutData (buf, pos);				
			if (c[i] == 1)
				kpsk->transmit (1);
      if (c[i] == 2)
				kpsk->transmit (0);
				pos=0;
			}
			else ++pos;
			++i;
    }
	free (c);
	}
}
/** Reinitializes the Main View */

void mainView::reInit()
{
	fixtext->setLabels();  /* Sets the Text of the fixtext labels */
  rxwindow->setFont (config.screen.rxwinfont);
	txwindow->setFont (config.screen.txwinfont);
	rxwindow->setColors (config.rxwincolor.rx, config.rxwincolor.tx);
  txwindow->setPaletteBackgroundColor(config.bkground.txb);
  rxwindow->setPaletteBackgroundColor(config.bkground.rxb);
	
}

/** Enable the callcheck of the RX Window */
void mainView::slotEnableCallcheck(bool s)
{
	rxwindow->setCallCheckEnabled(s);	
}
void mainView::slotClrMainRx()
{
  rxwindow->clear();
}
void mainView::slotClrTx()
{
  // clear tx window
  txwindow->clear();
  // also reset tx buffer
  commControl(COMM_TXCH, COMM_PTT, PTTOFF|PTTFORCE);
}
