/***************************************************************************
                          kpsktip.cpp  -  description
                             -------------------
    begin                : Sun Sep 22 2002
    copyright            : (C) 2002 by David Kjellquist
    email                : kpsk-develop@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*   The purpose of this class is subclass tootips and implement the       *
 *   maybeTip() method to allow dynamic tooltips identifying the channel   *
 *   for each cursor on the waterfall screen                               */


#include "globals.h"
#include "kpsktip.h"
#include <qtooltip.h>
#include <klocale.h>


#define FREQ_HEIGHT 22


// tooltip class constructor
KpskTip::KpskTip (QWidget* parent) : QToolTip(parent)
{
// nothing to do
}

KpskTip::~KpskTip()
{

}

	// Tool tips for the markers
void KpskTip::maybeTip (const QPoint &pos)
{
    int i;
     for (i=0; i<4; ++i){
      if (water->lastpos[i]>0)
        {
          if (water->stranslate[lastpos[i]-8]>pos.x() && water->stranslate[lastpos[i]+8]<pos.x())
             {
                if (i==0)
                  {
                  tip(QRect (water->stranslate[water->lastpos[i]-4], FREQ_HEIGHT, 8, 25), i18n ("Main Channel"));
                  }
                else
                  {
                  tip(QRect (water->stranslate[water->lastpos[i]-4], FREQ_HEIGHT, 8, 25), i18n ("Channel " + QString::number(i)));
				          }
             }
        }
      }
}


