 /**************************************************************************
 *   Copyright (C) 2005 by Danny Kukawka                                   *
 *                            <dkukawka@suse.de>, <danny.kukawka@web.de>   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/
 
/*! 
 *  \file 	dbusPowersave.h
 *  \brief 	Headerfile for dbusPowersave.cpp and the class \ref dbusPowersaveConnection.
 */
/*! 
 *  \class 	dbusPowersaveConnection
 *  \brief 	class for connection to powersave via D-BUS 
 *  \author 	Danny Kukawka, <dkukawka@suse.de>, <danny.kukawka@web.de>
 *  \version 	0.6.0
 *  \date    	2005
 */

#ifndef _DBUSPOWERSAVE_H_
#define _DBUSPOWERSAVE_H_

#ifndef DBUS_API_SUBJECT_TO_CHANGE
#define DBUS_API_SUBJECT_TO_CHANGE
#endif

// Global Header
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// QT - Header
#include <qstring.h>

// D-BUS Header
#include <dbus/message.h>
#include <dbus/connection.h>

// kpowersave - Header
#include "kpowersave_debug.h"

enum msg_type {
	NAME_AQUIRED,
	ACPI_EVENT,
	POWERSAVE_EVENT,
	PROGRESS,
	NOTIFICATION,
	SCREENLOCK,
	DBUS_EVENT
};

class dbusPowersaveConnection : public QObject{
	Q_OBJECT

private: 

	//! connection to D-BUS
	DBusQt::Connection* m_dBusQtConnection;
	//! to initialise the connection to D-BUS and powersave daemon
	bool initDBUS();
	//! to store information if KPowersave is connected
	/*!
	* This boolean represent information about the state of the connection
	* to D-BUS and powersave.
	* \li true:  if connected
	* \li false: if disconnected
	*/
	bool is_connected;

public:
	
	//! default constructor
	dbusPowersaveConnection();
	//! default destructor
	~dbusPowersaveConnection();

	//! to get information if KPowersave is connected to DBUS/powersave
	bool isConnected();
	//! to reconnect to D-BUS and powersave
	bool reconnect();
	//! to close the connection to D-BUS and powersave
	bool close();

	/* TODO: this is ugly, need to check if we can protect them !!! */
	//! wrapper to emit a signal with message to pdaemon
	void emitMsgReceived( msg_type, QString, int );

signals:
        //! signal with message to forward from D-BUS to pdaemon
	void msgReceived_withStringInteger( msg_type, QString ,int );
};

//! filter function to filter out needed information from D-BUS messages
DBusHandlerResult filter_function (DBusConnection *, DBusMessage *, void *);

#endif
