#include <stdio.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlineedit.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qsettings.h>
#include <qlayout.h>

#include "../dissipate2/sipcall.h"
#include "../dissipate2/sipuser.h"
#include "../dissipate2/sipregister.h"
#include "../dissipate2/sipclient.h"
#include "kphone.h"
#include "kphoneview.h"
#include "ksipauthentication.h"


KSipAuthenticationRequest::KSipAuthenticationRequest(
	const QString &server, const QString &sipuri, const QString &caption, QWidget *parent, const char *name )
	: QDialog( parent, caption, true )
{
	QVBox *vbox = new QVBox( this );
	vbox->setMargin( 3 );
	vbox->setSpacing( 3 );
	QVBoxLayout *vboxl = new QVBoxLayout( this, 5 );
	vboxl->addWidget( vbox );
	(void) new QLabel( tr("SipUri = ") + sipuri, vbox );
	(void) new QLabel( tr("Server = ") + server, vbox );
	(void) new QLabel( tr("Username:"), vbox );
	username = new QLineEdit( vbox );
	(void) new QLabel( tr("Password:"), vbox );
	password = new QLineEdit( vbox );
	password->setEchoMode( QLineEdit::Password );
	password->setFocus();
	savePassword = new QCheckBox( tr("Save password"), vbox );
	QHBoxLayout *buttonBox;
	buttonBox = new QHBoxLayout( vboxl, 6 );
	okPushButton = new QPushButton( this, tr("ok button") );
	okPushButton->setText( tr("OK") );
	okPushButton->setDefault( TRUE );
	buttonBox->addWidget( okPushButton );
	cancelPushButton = new QPushButton( this, tr("cancel button") );
	cancelPushButton->setText( tr("Cancel") );
	cancelPushButton->setAccel( Key_Escape );
	buttonBox->addWidget( cancelPushButton );
	connect( okPushButton, SIGNAL( clicked() ), this, SLOT( okClicked() ) );
	connect( cancelPushButton, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

KSipAuthenticationRequest::~KSipAuthenticationRequest( void )
{
}

void KSipAuthenticationRequest::setUsername( const QString &newUsername )
{
	username->setText( newUsername );
}

void KSipAuthenticationRequest::setPassword( const QString &newPassword )
{
	password->setText( newPassword );
}

QString KSipAuthenticationRequest::getUsername( void )
{
	return username->text();
}

QString KSipAuthenticationRequest::getPassword( void )
{
	return password->text();
}

void KSipAuthenticationRequest::okClicked( void )
{
	if (savePassword->isChecked())
		QSettings().writeEntry("/kphone/Registration/Password", getPassword());
	accept();
}

KSipAuthentication::KSipAuthentication()
{
	authreq = 0;
	execAuthreq = false;
}

KSipAuthentication::~KSipAuthentication( void )
{
}

void KSipAuthentication::authRequest( SipCallMember *member )
{
	if( member->getAuthState() != SipCallMember::authState_AuthenticationRequired &&
	    member->getAuthState() != SipCallMember::authState_AuthenticationRequiredWithNewPassword ) {
		return;
	}
	QString u = member->getCall()->getProxyUsername();
	QString p = member->getCall()->getPassword();
	if( execAuthreq ) return;
	if( p.isEmpty() ||
	    member->getAuthState() == SipCallMember::authState_AuthenticationRequiredWithNewPassword ) {
		QString proxy = member->getCall()->getSipProxy();
		SipUri localuri = member->getCall()->localAddress();
		if( !authreq ) {
			authreq = new KSipAuthenticationRequest( proxy, localuri.uri(), QString::null );
		}
		authreq->setUsername( u );
		authreq->setPassword( p );
		execAuthreq = true;
		if( authreq->exec() ) {
			u = authreq->getUsername();
			p = authreq->getPassword();
			if( u.isEmpty() || p.isEmpty() ) {
				return;
			}
			member->getCall()->setPassword( p );
			execAuthreq = false;
		} else {
			execAuthreq = false;
			return;
		}
	}

	switch( member->getCallMemberType() ){
		case SipCallMember::Subscribe:
			member->sendRequestSubscribe( u, p );
			break;
		case SipCallMember::Notify:
			member->sendRequestNotify( u, p );
			break;
		case SipCallMember::Message:
			member->sendRequestMessage( u, p );
			break;
		case SipCallMember::Invite:
			member->sendRequestInvite( u, p );
			break;
		default:
			break;
	}
}
