#ifndef KPHONE_H_INCLUDED
#define KPHONE_H_INCLUDED

#include <qmainwindow.h>

class SipClient;
class SipUser;
class PhoneList;
class CallAudio;
class AudioControl;
class VideoControl;
class KSipUserInfo;
class KPhoneView;
class KSipRegistrations;
class KSipAuthentication;
class KSipPreferences;
class KSipOptions;
class SipRegister;
class KTestOptions;
class TrayIcon;

QString const KPhoneVersion = "4.0.5";
int const quitTime = 5000;
int const ringTime_1 = 200;
int const ringTime_2 = 2000;
int const acceptTime = 500;
int const acceptSubscribeSendToSubscribe_time = 5000;
int const constRegistrationExpiresTime = 900;
int const constSubscribeExpiresTime = 600;
int const constStunRequestPeriod = 60;
int const constMinPort = 0;
int const constMaxPort = 0;
int const kphoneMinimunWidht = 220;
QString const constStunServer = "stun.wirlab.net:3478";


class KPhone : public QMainWindow
{
	Q_OBJECT
public:
	KPhone( unsigned int listenport, QString prefix, bool looseRoute, bool strictRoute );
	~KPhone( void );
	void showUsers( void );
	QString getUserPrefix( void );

public slots:
	void showHelp( void );
	void updateTrayIcon( void );
	void toggleVisibility( void );
	void trayMenuRequested( const QPoint& pos );

private slots:
	void timerTick( void );
	void stun_timerTick( void );
	void showUserInfo( void );
	void showAudioPreferences( void );
	void showVideoPreferences( void );
	void showRegistrations( void );
	void showGlobalPreferences( void );
	void showQueryOptions( void );
	void showTestOptions( void );
	void showAboutKPhone( void );
	void toggleTrayIcon( int );
	void kphoneQuit( void );

protected:
	void closeEvent( QCloseEvent* );
	void createTrayIcon( void );
	void deleteTrayIcon( void );
	KPhoneView *view;
	TrayIcon *trayIcon;

	// Global state
	SipClient *client;
	SipUser *user;
	CallAudio *audio;
	QPopupMenu *preferencesMenu;

	// Dialogs
	PhoneList *qdial;
	KSipUserInfo *userinfo;
	AudioControl *audiocontrol;
	VideoControl *videocontrol;
	KSipRegistrations *registrations;
	KSipAuthentication *authentication;
	KSipPreferences *sipprefs;
	KSipOptions *queryoptions;
	KTestOptions *testoptions;

private:
	QTimer *quitTimer;
	QString userPrefix;

};

#endif // KPHONE_H_INCLUDED
