/*
    Kopete Yahoo Protocol
    Receive Messages

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "messagereceivertask.h"

#include <qstring.h>

#include "transfer.h"
#include "ymsgtransfer.h"
#include "yahootypes.h"
#include "client.h"
#include "yahoo_protocol_debug.h"

using namespace KYahoo;

MessageReceiverTask::MessageReceiverTask(Task* parent) : Task(parent)
{
	qCDebug(YAHOO_PROTOCOL_LOG) ;
}

MessageReceiverTask::~MessageReceiverTask()
{
}

bool MessageReceiverTask::take( Transfer* transfer )
{
	if ( !forMe( transfer ) )
		return false;

	YMSGTransfer *t = nullptr;
	t = dynamic_cast<YMSGTransfer*>(transfer);
	if (!t)
		return false;
	
	if( t->service() == Yahoo::ServiceNotify )
	{
		parseNotify( t );
	}
	else
	{
		if( t->service() == Yahoo::ServiceAnimatedAudibleIcon )
		{
			parseAnimatedAudibleIcon( t );
		}
		else
		{
			parseMessage( t );
		}
	}

	return true;
}

bool MessageReceiverTask::forMe( const Transfer* transfer ) const
{
	const YMSGTransfer *t = nullptr;
	t = dynamic_cast<const YMSGTransfer*>(transfer);
	if (!t)
		return false;

	if ( t->service() == Yahoo::ServiceMessage ||
		t->service() == Yahoo::ServiceGameMsg ||
		t->service() == Yahoo::ServiceSysMessage ||
		t->service() == Yahoo::ServiceNotify ||
		t->service() == Yahoo::ServiceAnimatedAudibleIcon )	
		return true;
	else
		return false;
}

void MessageReceiverTask::parseMessage( YMSGTransfer *t )
{
	qCDebug(YAHOO_PROTOCOL_LOG) ;

	int cnt = t->paramCount( 5 );
	for( int i = 0; i < cnt; ++i )
	{
		QString to = t->nthParam( 5, i );
		QString timestamp = t->nthParamSeparated( 15, i, 4 );
		QString utf8 = t->nthParamSeparated( 97, i, 4 );
		QString from = t->nthParamSeparated( 1, i, 4 ).isEmpty() ? t->nthParam( 4, i ) : t->nthParamSeparated( 1, i, 4 );
		QString msg = t->nthParamSeparated( 14, i, 4 );
		QString sysmsg = t->nthParamSeparated( 16, i, 4 );

		// The arrangement of the key->value pairs is different when there is only one message in the packet.
		// Separating by key "5" (sender) doesn't work in that case, because the "1" and "4" keys are sent before the "5" key
		if( cnt == 1 )
			from = t->firstParam( 1 ).isEmpty() ? t->firstParam( 4 ) : t->firstParam( 1 );

		if( !sysmsg.isEmpty() )
		{
			client()->notifyError( QStringLiteral("Server message received: "), sysmsg, Client::Error );
			continue;
		}
	
		if( msg.isEmpty() )
		{
			qCDebug(YAHOO_PROTOCOL_LOG) << "Got a empty message. Dropped.";
			continue;
		}
	
		if( utf8.startsWith( '1' ) )
			msg = QString::fromUtf8( msg.toLatin1() );
	
		if( t->service() == Yahoo::ServiceSysMessage )
			emit systemMessage( sysmsg );
		else
		{	
			if( msg.startsWith( QLatin1String("<ding>") ) )
				emit gotBuzz( from, timestamp.toLong() );
			else
				emit gotIm( from, msg, timestamp.toLong(), 0);
		}
	}
}

void MessageReceiverTask::parseAnimatedAudibleIcon( YMSGTransfer *t )
{
	// added by michaelacole
	qCDebug(YAHOO_PROTOCOL_LOG) ;

	int cnt = t->paramCount( 5 );
	for( int i = 0; i < cnt; ++i )
	{
		QString to = t->nthParam( 5, i );
		QString from = t->nthParamSeparated( 1, i, 4 ).isEmpty() ? t->nthParam( 4, i ) : t->nthParamSeparated( 1, i, 4 );
		QString msg = t->nthParamSeparated( 231, i, 4 );
		QString msg2 = t->nthParamSeparated( 230, i, 4 );
		QString utf8 = t->nthParamSeparated( 97, i, 4 );
		QString timestamp = t->nthParamSeparated( 15, i, 4 );

		// The arrangement of the key->value pairs is different when there is only one message in the packet.
		// Separating by key "5" (sender) doesn't work in that case, because the "1" and "4" keys are sent before the "5" key
		if( cnt == 1 )
			from = t->firstParam( 1 ).isEmpty() ? t->firstParam( 4 ) : t->firstParam( 1 );

		if( msg.isEmpty() )
		{
			qCDebug(YAHOO_PROTOCOL_LOG) << "Got a empty message. Dropped.";
			continue;
		}

		if( utf8.startsWith( '1' ) )
		{
			msg = QString::fromUtf8( msg.toLatin1() );
		}
		
		msg = "ANIMATED AUDIBLE SENT TO YOU WITH TEXT " + msg;
		emit gotIm( from, msg, timestamp.toLong(), 0);
		msg2 = "http://us.dl1.yimg.com//download.yahoo.com/dl/aud/"+msg2.mid(5,2)+"/" + msg2 + ".swf";
		emit gotIm( from, msg2,timestamp.toLong(), 0);

	}
}

void MessageReceiverTask::parseNotify( YMSGTransfer *t )
{
	qCDebug(YAHOO_PROTOCOL_LOG) ;

	QString from = t->firstParam( 4 );
	//QString to = t->firstParam( 5 );
	QString type = t->firstParam( 49 );
	QString stat = t->firstParam( 13 );
	QString ind = t->firstParam( 14 );

	if( type.startsWith( QLatin1String("TYPING") ) )
		emit gotTypingNotify( from, stat.toInt() );
	else if( type.startsWith( QLatin1String("GAME") ) )
		;
	else if( type.startsWith( QLatin1String("WEBCAMINVITE") ) )
	{
		if( ind.startsWith(' ') )
		{
			qCDebug(YAHOO_PROTOCOL_LOG) << "Got a WebcamInvitation.";
			emit gotWebcamInvite( from );
		}
		else
		{
			qCDebug(YAHOO_PROTOCOL_LOG) << "Got a WebcamRequest-Response: " << ind.toInt();
		}
	}
}

