//              -*- mode: C++ -*-
// Copyright(C) 2005 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KOPETESILC_SILCEDITACCOUNTWIDGET_H
#define KOPETESILC_SILCEDITACCOUNTWIDGET_H

#include <ui/editaccountwidget.h>

// import the base widget class
#include "silceditaccount.h" 

// include libsilc stuff into a separate namespace
namespace SilcTK {
#include <silc.h>
#include <silcclient.h>
}


// forward declarations
class SilcProtocol;
class SilcAccount;

/**
 * @brief create the KopeteEditAccountWidget
 *
 * @author Stefan Siegl <stesie@brokenpipe.de>
 */
class SilcEditAccountWidget :
  public SilcEditAccount,
  public KopeteEditAccountWidget {
  Q_OBJECT;

public:
  SilcEditAccountWidget(SilcProtocol *proto, SilcAccount *account,
			QWidget *parent);
  ~SilcEditAccountWidget();

  /**
   * @brief validate the data, entered by the user
   *
   * Validate the data entered by the user.  In error case a suitable error
   * message is displayed.
   *
   * @return true if the entered data is valid, false on error
   */
  virtual bool validateData(void);

  /**
   * @brief apply the settings made by the user to the concerned SilcAccount
   *
   * @return pointer to (maybe new allocated) SilcAccount class
   */
  virtual Kopete::Account *apply(void);

  /**
   * @brief collect mood setting from attribute tab
   */
  SilcTK::SilcAttributeMood getAttributeMood(void);

  /** 
   * @brief set mood setting to attribute tab
   */
  void setAttributeMood(SilcTK::SilcAttributeMood mood);
  
  /**
   * @brief collect contact setting from attribute tab
   */
  SilcTK::SilcAttributeContact getAttributeContact(void);

  /** 
   * @brief set mood setting to attribute tab
   */
  void setAttributeContact(SilcTK::SilcAttributeContact contact);

private slots:
  void slotRemoveServerKey(void);
  void slotGeoAllowToggle(bool value);
  void slotAllowToggle(bool value);

private:
  QStringList serverKeysToDelete;
};

#endif // KOPETESILC_SILCEDITACCOUNTWIDGET_H
