/**************************************************************************
*   Copyright (C) 2006 by Conrad Hoffmann                                 *
*   conrausch@gmx.de                                                      *
*   http://conrausch.doesntexist.org                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/


#include <qwidget.h>
#include <qimage.h>

#include <ksharedpixmap.h>
#include <kpixmapio.h>
#include <kimageeffect.h>
#include <kdebug.h>

#include "kopetedesklistrootpixmap.h"

KopeteDesklistRootPixmap::KopeteDesklistRootPixmap( QWidget* target )
		: KRootPixmap( target ),
		m_targetWidget( target )
{
}


void KopeteDesklistRootPixmap::updateBackground( KSharedPixmap* pixmap )
{
	QPixmap pm = *pixmap;
	
	if ( opacity() > 1e-6 )
	{
		KPixmapIO io;
		QImage img = io.convertToImage( pm );
		if ( img.width() == 1 && img.height() == 1 ) // user has solid background
			img = img.scale( m_targetWidget->width(), m_targetWidget->height() );

		QImage faded = img.copy();
		KImageEffect::fade( faded, opacity(), color() );

		QImage slightlyLessFaded = img.copy(); // pseudo antialiasing :D
		KImageEffect::fade( slightlyLessFaded, opacity() / 1.5, color() );

		// hooray for eyecandy, to hell with efficiency ;)
		int x_val, y_val; // don't mess up loop vars
		for ( int x_index = 0; x_index < img.width(); x_index++ )
		{
			for ( int y_index = 0; y_index < img.height(); y_index++ )
			{
				x_val = x_index;
				y_val = y_index;

				if ( x_val > 10 )
				{
					x_val = ( img.width() - 1 ) - x_index;
				}
				if ( y_val > 10 )
				{
					y_val = ( img.height() - 1 ) - y_index;
				}
				x_val = 10 - x_val;
				y_val = 10 - y_val;
				if ( x_val*x_val + y_val*y_val >= 100 )
				{		
					if ( x_val*x_val + y_val*y_val <= 115 )
					{ // pseudo antialiasing :D
						faded.setPixel( x_index, y_index, slightlyLessFaded.pixel( x_index, y_index ) );
					}
					else
					{
						faded.setPixel( x_index, y_index, img.pixel( x_index, y_index ) );
					}
				}
				// weiered code, but the only efficiency booster i could come up with
				if ( y_index == 10 )
					y_index = img.height() - 10; // skip all unneeded pixels
			}

			// weiered code, but the only efficiency booster i could come up with
			if ( x_index == 10 )
				x_index = img.width() - 10; // skip all unneeded pixels
		}

		pm = io.convertToPixmap( faded );
	}

	m_targetWidget->setBackgroundPixmap( pm );
}


