/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "DnsResolverUi.h"

DnsResolverUi::DnsResolverUi()
{
        m_Label_Domain = new QLabel(tr("&Domain :"), this);
        m_Label_Ip = new QLabel(tr("&Ip :"), this);
        m_Line_Domain = new QLineEdit(this);
        m_Line_Ip = new QLineEdit(this);
        closeButton = new QPushButton(tr("Close"), this);
        m_Label_Domain->setBuddy(m_Line_Domain);
        m_Label_Ip->setBuddy(m_Line_Ip);
        m_Button_Ip = new QPushButton(tr("Resolve IP"),this);
        m_Button_Domain = new QPushButton(tr("Resolve Domain"),this);

        QHBoxLayout* Layout = new QHBoxLayout();
        Layout->addWidget(m_Label_Domain);
        Layout->addWidget(m_Line_Domain);
        Layout->addWidget(m_Label_Ip);
        Layout->addWidget(m_Line_Ip);
        Layout->addWidget(m_Button_Domain);
        Layout->addWidget(m_Button_Ip);
        Layout->addWidget(closeButton);
        setLayout(Layout);

        connect(this->m_Button_Ip, SIGNAL(clicked(bool)), this, SLOT(resolveIp(bool)));
        connect(this->m_Button_Domain, SIGNAL(clicked(bool)), this, SLOT(resolveDomain(bool)));
        connect(closeButton, SIGNAL(clicked()), this, SLOT(reject()));
}

void DnsResolverUi::resolveDomain(bool valid)
{
    QHostInfo infoAdresse = QHostInfo::fromName(m_Line_Domain->text());
    QList<QHostAddress> result_adresses = infoAdresse.addresses();
    QString Ip;
    for(int i=0; i < result_adresses.size(); i++)
    {
        Ip = Ip + result_adresses.at(i).toString() +"; ";
    }
    m_Line_Ip->setText(Ip);
}

void DnsResolverUi::resolveIp(bool valid)
{
    QHostInfo::lookupHost(m_Line_Ip->text(),this, SLOT(resolveIpFinish(QHostInfo)));
}

void DnsResolverUi::resolveIpFinish(const QHostInfo& infoAdresse)
{
    m_Line_Domain->setText(infoAdresse.hostName());
}


