/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include <QLineEdit>
#include <QTabWidget>
#include <QStringListModel>
#include <QGridLayout>
#include <QTextEdit>
#include <QUrl>
#include <QGroupBox>
#include <QLabel>
#include <QStringList>
#include <QCompleter>
#include <QMessageBox>
#include <QMap>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QList>
#include "RemoteClientWidget.h"
#include "../core/Server.h"
#include "ServerHome.h"
#include "Workstation.h"
#include "FileTransfertClientWidget.h"

class CentralWindow : public QWidget
{
    Q_OBJECT

public:
	CentralWindow();
	QSize minimumSizeHint() const;
        ServerHome *serverHome;
	QMap<int, RemoteClientWidget*> *map;
        QMap<int, FileTransfertClientWidget*> *fileMap;
        QMap<int, QTabWidget*> *clientTabMap;
        QMap<QString, int> *mapParams;
	QSize sizeHint() const;
        QStringList completionList;
	QTabWidget *tab;
	int index;
	int tabNumber;
	QStringList commandsStringList;
	void addTab(QStringList parameters, int clientNbr);
        QTextBrowser *textEdit;
	QLineEdit *commandLineEdit;
	QString getCommand();
        int getSelectedClient();
        void displayLoading(int clientNumber);

public slots:
	void exec();
        void changeDir(QString command, int clientNbr);
	void setCommand(QString command);
	void displayStartedServer(QString ipAddress, QString port, bool status);
	void getClientParameters(QStringList params, int clientNbr);
	void removeTab(QString title, int clientNbr);
	void getUpCommand();
	void getDownCommand();
	void clearCommand();
        void displayResults(QString *results, int clientNbr);
        void getClientContext(QStringList context, int clientNbr);
        void getFilePathFromFileTransfertWidget(QString filePath, int clientNbr);
        void getFileFromRemoteClient(QString filePath, int clientNbr);
        void fileSent(int clientNbr);

signals:
        void startNextThread();
        void removeRemoteClient(int clientNbr);
        void refreshMainWindowTitle();
	void sendCommandToClient(QString command, int clientNbr);
	void sendCommandToDisplay(QString command);
	void sendContext(QString context);	
	void sendPathPossibilityToCommandLineEdit(QStringList list);	
	void notifyToolBar();
	void notifyDialog(QString results);
        void sendFileToRemoteClient(QString filePath, int clientNbr);
        void askFileFromRemoteClient(QString filePath, int clientNbr);
        void resetProgressBar(int clientNbr);
        void incrementProgressBar();
        void fileSentSignal(int clientNbr);

private:
	
};
