/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "CentralWindow.h"

CentralWindow::CentralWindow()
{	
    QGridLayout *layout = new QGridLayout(this);
    fileMap = new QMap<int, FileTransfertClientWidget*>();
    map = new QMap<int, RemoteClientWidget*>();
    mapParams = new QMap<QString, int>();
    clientTabMap = new QMap<int, QTabWidget*>();
    tab = new QTabWidget(this);
    QGridLayout *vbox = new QGridLayout(this);
    QWidget *background = new QWidget;
    commandLineEdit = new QLineEdit(this);
    commandLineEdit->setToolTip(tr("Input commands and press Return"));
    #ifdef WIN32
    commandLineEdit->setFont(QFont("Courier", 12));
    #elif defined (linux)
    commandLineEdit->setFont(QFont("Courier", 12));
    #elif defined __APPLE__
    commandLineEdit->setMinimumHeight(25);
    commandLineEdit->setFont(QFont("Courier", 14));
    #endif
    setFocusProxy(commandLineEdit);
    QLabel *label= new QLabel(tr("Input commands into the field below :"), this);
    textEdit = new QTextBrowser(this);
    textEdit->setReadOnly (true);
    textEdit->ensureCursorVisible();
    textEdit->setLineWrapMode(QTextEdit::FixedColumnWidth);
    textEdit->setLineWrapColumnOrWidth(1000);
    textEdit->textCursor().insertHtml(
            QString(tr("<font color=\"#000000\">")
            +
            tr("KontrolPack improves interoperability between systems by connecting remote computers, regardless of their operating system.<ul><li><img src=\":/icons/system-file-manager.png\"/>&nbsp;&nbsp;&nbsp;Navigate through remote file systems.</li><li><img src=\":/icons/cmd2.png\"/>&nbsp;&nbsp;&nbsp;Handle <b>remote shell command execution</b>.</li><li><img src=\":/icons/document-save.png\"/>&nbsp;&nbsp;&nbsp;<b>Share files between remote computers</b>.</li><li><img src=\":/icons/network-map.png\"/>&nbsp;&nbsp;&nbsp;Get an overview of the <b>workstations on your LAN</b>.</li>")
            +tr("</ul><br/> Start the server before connecting remote clients. (Menu 'Settings'->'Server settings'->'Start')<br /><br /><br />Each time a client will connect to this server session a new tab corresponding to this new client will be added.</font><br/><br/><div align=\"center\"><img src=\":/icons/tab-panel.png\"/></div>")
                                            + tr("<br/><br /><font color=\"#006633\">KontrolPack can be started in two different modes : Server mode or Client mode (server/client).<br />Each Server can control remotely hundreds of KontrolPack started in Client mode.<br /><br />")
                                            + tr("</font><br/>")));
    serverHome = new ServerHome(textEdit, this);
    tab->addTab(serverHome, QIcon(":/icons/connection.png"), tr("Server"));
    vbox->addWidget(tab, 0, 0);
    vbox->addWidget(label, 1, 0);
    vbox->addWidget(commandLineEdit,2, 0);
    background->setLayout(vbox);
    layout->addWidget(background, 0, 0);
}


void CentralWindow::getClientParameters(QStringList params, int clientNbr)
{
        addTab(params, clientNbr);
}

void CentralWindow::addTab(QStringList parameters, int clientNbr)
{
        QString title = parameters.at(1) + " " + parameters.at(0);
        QLabel *image = new QLabel(this);
        QLabel *imageMap = new QLabel(this);
        if (title.startsWith(QString("LINUX"), Qt::CaseSensitive))
        {
                image->setPixmap(QPixmap(":/icons/120px-Computer-linux2.png"));
                imageMap->setPixmap(QPixmap(":/icons/120px-Computer-linux2-small.png"));
        } else if (title.startsWith("WINDOWS", Qt::CaseSensitive))
        {
                image->setPixmap(QPixmap(":/icons/120px-Computer-windows.png"));
                imageMap->setPixmap(QPixmap(":/icons/120px-Computer-windows-small.png"));
        }else if (title.startsWith("MACOSX", Qt::CaseSensitive))
        {
                image->setPixmap(QPixmap(":/icons/120px-Computer-mac.png"));
                imageMap->setPixmap(QPixmap(":/icons/120px-Computer-mac-small.png"));
        }
        Workstation *workstation = new Workstation(parameters, imageMap, this);
        serverHome->addWorkstation(workstation);
        textEdit->textCursor().insertHtml(
                QString(tr("<font color=\"#006633\"><br />A remote ") + title + tr(" computer is connected to this server.</font>")));
        FileTransfertClientWidget *fileClientWidget = new FileTransfertClientWidget(clientNbr, image, parameters, this);
        RemoteClientWidget *clientWidget = new RemoteClientWidget(clientNbr, image, parameters, tr("Loading..."), this);
        connect(clientWidget, SIGNAL(setCommandLine(QString)), this, SLOT(setCommand(QString)));
        connect(clientWidget, SIGNAL(sendCommand(QString, int)), this, SLOT(changeDir(QString, int)));
        connect(fileClientWidget, SIGNAL(sendFileToRemoteClient(QString, int)), this, SLOT(getFilePathFromFileTransfertWidget(QString, int)));
        connect(fileClientWidget, SIGNAL(getFileFromRemoteClient(QString, int)), this, SLOT(getFileFromRemoteClient(QString, int)));
        connect(fileClientWidget, SIGNAL(changeDirectory(QString, int)), this, SLOT(changeDir(QString, int)));
        connect(this, SIGNAL(fileSentSignal(int)), fileClientWidget, SLOT(fileSent(int)));

        QTabWidget *clientTab = new QTabWidget(this);
        clientTab->setTabPosition(QTabWidget::West);
        clientTab->addTab(clientWidget, QIcon(":/icons/cmd2.png"), "Shell commands");
        clientTab->addTab(fileClientWidget, QIcon(":/icons/document-save.png"), "Share files");
        tabNumber = tab->count();
        map->insert(clientNbr, clientWidget);
        fileMap->insert(clientNbr, fileClientWidget);
        mapParams->insert(title, clientNbr);
        clientTabMap->insert(clientNbr, clientTab);
        if (title.startsWith(QString("LINUX"), Qt::CaseSensitive))
        {
                tab->addTab(clientTab, QIcon(":/icons/Tux_bg-small.png"), title);
        } else if (title.startsWith("WINDOWS", Qt::CaseSensitive))
        {
                tab->addTab(clientTab, QIcon(":/icons/Windows-small.png"), title);
        }else if (title.startsWith("MACOSX", Qt::CaseSensitive))
        {
                tab->addTab(clientTab, QIcon(":/icons/mac.png"), title);
        }else if (title.startsWith("SOLARIS", Qt::CaseSensitive))
        {
                tab->addTab(clientTab, QIcon(":/icons/kontrol-icon.png"), title);
        }else if (title.startsWith("UNIX", Qt::CaseSensitive))
        {
                tab->addTab(clientTab, QIcon(":/icons/kontrol-icon.png"), title);
        }
        tab->setCurrentIndex(tab->count()+1);
        emit refreshMainWindowTitle();
}

QString CentralWindow::getCommand()
{
  QString text = commandLineEdit->text();
  commandLineEdit->setText("");
  return text;
}

void CentralWindow::setCommand(QString command)
{
	commandLineEdit->setText(command);    
}

void CentralWindow::displayLoading(int clientNumber)
{
    QTextEdit *browser = map->value(clientNumber)->textBrowser;
    browser->setReadOnly(true);
    browser->ensureCursorVisible();
    browser->textCursor().insertHtml(tr("Please, your command is being executing remotely... Wait a few moments, results will be displayed below.<br/><br/><br/>"));

}

void CentralWindow::exec()
{
    if (commandLineEdit->text() != "")
    {
        int clientNumber = mapParams->value(tab->tabText(tab->currentIndex()));
        if (clientNumber != -1 && clientNumber != 0 && map->size() != 0)
        {
            QTextEdit *browser = map->value(clientNumber)->textBrowser;
            browser->clear();
            browser->setReadOnly(true);
            browser->ensureCursorVisible();
            browser->textCursor().insertHtml(tr("<br /><font color=\"#006633\"><font color=\"#000000\">[Executed command] $ </font><font color=\"#006633\">") +commandLineEdit->text() + tr("</font><br /></font><font color=\"#000033\"><br /></font><br/>"));
        }
        if (clientNumber != -1 && clientNumber != 0)
        {
          emit sendCommandToClient(commandLineEdit->text(), clientNumber);
          commandsStringList.append(commandLineEdit->text());
          commandLineEdit->setText("");
        } else {
                QMessageBox::information(this, tr("Warning"), tr("Select a tab corresponding to a specific remote computer to send a command."));
        }
    } else {
            QMessageBox::information(this, tr("Warning"), tr("Input a command in the field below to start executing commands."));
    }
}

void CentralWindow::changeDir(QString command, int clientNbr)
{
    QTextEdit *browser = map->value(clientNbr)->textBrowser;
    browser->clear();
    browser->setReadOnly(true);
    browser->ensureCursorVisible();
    browser->textCursor().insertHtml(tr("<br /><font color=\"#006633\"><font color=\"#000000\">[Executed command] $ </font><font color=\"#006633\">") + command + tr("</font><br /></font><font color=\"#000033\"><br /></font><br/>"));
    emit sendCommandToClient(command, clientNbr);
    commandsStringList.append(command);
    commandLineEdit->setText("");
}

void CentralWindow::removeTab(QString title, int clientNbr)
{	
	textEdit->setReadOnly(true);
        textEdit->textCursor().insertHtml(tr("<font color=\"#006633\"><br />The remote ") + title + tr(" computer is disconnected.</font>"));
        int indexToRemove = tab->indexOf(clientTabMap->value(clientNbr));
	tab->removeTab(indexToRemove);
	map->remove(clientNbr);
        fileMap->remove(clientNbr);
        mapParams->remove(title);
        clientTabMap->remove(clientNbr);
}

void CentralWindow::getDownCommand() 
{
	if (commandsStringList.size() != 0) {
		if (index <= commandsStringList.size() - 1 && index >= 0) {
			commandLineEdit->setText(commandsStringList.at(index));
			index = (index + 1);
		} else {
			index = 0;
			commandLineEdit->setText(commandsStringList.at(index));
		}
	}	
}

void CentralWindow::getUpCommand() 
{
	if (commandsStringList.size() != 0) {
		if (index <= commandsStringList.size() - 1 && index >= 0) {
			commandLineEdit->setText(commandsStringList.at(index));
			index = (index - 1);
		} else {
			index =  commandsStringList.size() - 1;
			commandLineEdit->setText(commandsStringList.at(index));
		}
	} else {
		commandLineEdit->setText("");
	}
}

void CentralWindow::clearCommand()
{
    if (commandLineEdit->text() != "")
    {
        commandLineEdit->setText("");
    } else {
            QMessageBox::information(this, tr("Warning"), tr("Nothing to clean, input a command in the field at the bottom of the interface."));
    }
}

void CentralWindow::displayStartedServer(QString ipAddress, QString port, bool status)
{
	if (!status)
	{
		textEdit->clear();
                textEdit->insertHtml(QString(tr("<font color=\"#000000\"><b>Server mode stopped.<br /><br />Each clients are now disconnected.</b><br /><br /></font>")
                + tr("<font color=\"#000000\">KontrolPack improves interoperability between systems by connecting remote computers, regardless of their operating system.<ul><li><img src=\":/icons/system-file-manager.png\"/>&nbsp;&nbsp;&nbsp;Navigate through remote file systems.</li><li><img src=\":/icons/cmd2.png\"/>&nbsp;&nbsp;&nbsp;Handle <b>remote shell command execution</b>.</li><li><img src=\":/icons/document-save.png\"/>&nbsp;&nbsp;&nbsp;<b>Share files between remote computers</b>.</li><li><img src=\":/icons/network-map.png\"/>&nbsp;&nbsp;&nbsp;Get an overview of the <b>workstations on your LAN</b>.</li>")
                + tr("</ul><br/> Start the server before connecting remote clients. (Menu 'Settings'->'Server settings'->'Start')<br /><br /><br />Each time a client will connect to this server session a new tab corresponding to this new client will be added.</font><br/><br/><div align=\"center\"><img src=\":/icons/tab-panel.png\"/></div>")
                                                + tr("<br/><br /><font color=\"#006633\">KontrolPack can be started in two different modes : Server mode or Client mode (server/client).<br />Each Server can control remotely hundreds of KontrolPack started in Client mode.<br /><br />")
                                                + tr("</font><br/>")));
	} else {
		textEdit->clear();
		textEdit->insertHtml(
                        QString(tr("<font color=\"#000000\"><b>Server mode started succesfully.<br />--------------------------------<br /><br />IP : ") + ipAddress + tr("<br />Listened port : ") + port + tr("<br /><br />Waiting for client connection ...</b><br /><br /><br />")
                + tr("<font color=\"#000000\">KontrolPack improves interoperability between systems by connecting remote computers, regardless of their operating system.<ul><li><img src=\":/icons/system-file-manager.png\"/>&nbsp;&nbsp;&nbsp;Navigate through remote file systems.</li><li><img src=\":/icons/cmd2.png\"/>&nbsp;&nbsp;&nbsp;Handle <b>remote shell command execution</b>.</li><li><img src=\":/icons/document-save.png\"/>&nbsp;&nbsp;&nbsp;<b>Share files between remote computers</b>.</li><li><img src=\":/icons/network-map.png\"/>&nbsp;&nbsp;&nbsp;Get an overview of the <b>workstations on your LAN</b>.</li>")
                + tr("</ul><<br/> Start the server before connecting remote clients. (Menu 'Settings'->'Server settings'->'Start')<br /><br /><br />Each time a client will connect to this server session a new tab corresponding to this new client will be added.</font><br/><br/><div align=\"center\"><img src=\":/icons/tab-panel.png\"/></div>")
                                                + tr("<br/><br /><font color=\"#006633\">KontrolPack can be started in two different modes : Server mode or Client mode (server/client).<br />Each Server can control remotely hundreds of KontrolPack started in Client mode.<br /><br />")
                                                + tr("</font><br/>")));
	}
}

void CentralWindow::displayResults(QString *results, int clientNbr)
{
        QTextEdit *browser = map->value(clientNbr)->textBrowser;
        browser->setFont(QFont("Lucida Console"));
	browser->setReadOnly(true);
	browser->ensureCursorVisible();
        if (results->contains("####EXECUTED COMMAND####")) {

            browser->textCursor().insertHtml("<font color=\"#006633\">" + *results + "</font><br/><br/>");
            emit startNextThread();
            emit resetProgressBar(clientNbr);
        } else {
            browser->textCursor().insertHtml(*results + "<br/><br/>");
            //emit incrementProgressBar();
        }
        delete results;
}

void CentralWindow::getClientContext(QStringList context, int clientNbr)
{
    if (map->contains(clientNbr)) {
	QLabel *label = map->value(clientNbr)->path;
        if (QString::compare(label->text(), context.at(0), Qt::CaseSensitive) != 0)
        {
            label->setText("<b>" + context.at(0) + "</b>");
            fileMap->value(clientNbr)->remotePath->setText("<b>" + context.at(0) + "</b>");
            context.removeAt(0);
            QString nbrFolder = context.at(0);
            context.removeAt(0);
            context.removeAt(0);
            QStringList foldersList = QStringList();
            QStringList filesList = QStringList();
            QStandardItemModel *remoteDocumentsIconModel = new QStandardItemModel(this);
            for (int i = 0; i < nbrFolder.toInt() - 1; ++i) {
                QStandardItem *item = new QStandardItem(QIcon(":/icons/folder.png") ,context.at(i));
                item->setEditable(false);
                QStandardItem *itemFileView = new QStandardItem(QIcon(":/icons/folder.png") ,context.at(i));
                itemFileView->setEditable(false);
                foldersList.append(context.at(i));
                remoteDocumentsIconModel->appendRow(itemFileView);
            }
            QList<QStandardItem *> remoteFilesIconList = QList<QStandardItem *>();
            for (int k = nbrFolder.toInt() - 1; k < context.size(); ++k) {
                QStandardItem *item = new QStandardItem(QIcon(":/icons/file.png") ,context.at(k));
                item->setEditable(false);
                filesList.append(context.at(k));
                remoteDocumentsIconModel->appendRow(item);
            }
            map->value(clientNbr)->remoteFoldersList = foldersList;
            map->value(clientNbr)->remoteFilesList = filesList;
            map->value(clientNbr)->list->setModel(remoteDocumentsIconModel);
            fileMap->value(clientNbr)->remoteFilesList = filesList;
            fileMap->value(clientNbr)->remoteFoldersList = foldersList;
            fileMap->value(clientNbr)->remoteList->setModel(remoteDocumentsIconModel);
            QStringList pathPosssibility = QStringList();
            for (int j = 0; j < foldersList.size(); ++j) {
                    if (QString::compare(foldersList.at(j), ".", Qt::CaseSensitive) != 0)
                        pathPosssibility.append(QString("cd ") + foldersList.at(j));
            }
            QCompleter *completer = new QCompleter(pathPosssibility, this);
            completer->setCompletionMode(QCompleter::InlineCompletion);
            completer->setCaseSensitivity(Qt::CaseSensitive);
            commandLineEdit->setCompleter(completer);
        }
    }
}

int CentralWindow::getSelectedClient()
{
    return mapParams->value(tab->tabText(tab->currentIndex()));
}

void CentralWindow::getFilePathFromFileTransfertWidget(QString filePath, int clientNbr)
{
    emit sendFileToRemoteClient(filePath, clientNbr);
}

void CentralWindow::getFileFromRemoteClient(QString filePath, int clientNbr)
{
    emit askFileFromRemoteClient(filePath, clientNbr);
}

QSize CentralWindow::minimumSizeHint() const
{
    return QSize(25, 25);
}

QSize CentralWindow::sizeHint() const
{
    return QSize(200, 200);
}

void CentralWindow::fileSent(int clientNbr)
{
    emit fileSentSignal(clientNbr);
}
