/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "XmlCreator.h"

XmlCreator::XmlCreator(QObject *parent)
         : QObject(parent)
{
}

QString XmlCreator::createXmlCommandFlow(QString buffer)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("command");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement commandNode = doc.createElement("command");
    commandNode.appendChild(doc.createTextNode(buffer));
    mainNode.appendChild(commandNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString());
}

QString XmlCreator::createXmlSendFileFlow(QString buffer, int fileSize)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("fileSender");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement filePathNode = doc.createElement(FILE_NAME);
    QDomElement fileSizeNode = doc.createElement(FILE_SIZE);
    filePathNode.appendChild(doc.createTextNode(buffer));
    fileSizeNode.appendChild(doc.createTextNode(QString::number(fileSize)));
    mainNode.appendChild(filePathNode);
    mainNode.appendChild(fileSizeNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString());
}

QString XmlCreator::createXmlAskFileFlow(QString fileName)
{
    QDomImplementation impl = QDomDocument().implementation();
    QDomDocument doc("fileAsker");
    QDomElement mainNode = doc.createElement(KONTROLPACK);
    QDomElement fileNameNode = doc.createElement(FILE_NAME);
    fileNameNode.appendChild(doc.createTextNode(fileName));
    mainNode.appendChild(fileNameNode);
    doc.appendChild(mainNode);
    return transformXmlToLine(doc.toString());
}

void XmlCreator::createXmlInitialisationFlow(const char *buffer)
{
}

QString XmlCreator::transformXmlToLine(QString xml)
{
    return xml.replace("\n", "") + "\n";
}



