/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#ifndef HEADER_CLIENT
#define HEADER_CLIENT

#include <QObject>
#include <QThread>
#include <QtNetwork>
#include <QStringList>
#include "communication/XmlResultsParser.h"
#include "main/common/xml_constants.h"

class Client : public QObject
{
	 Q_OBJECT

public:
	Client(QTcpSocket *socket, int clientNbr, QObject *parent);
	XmlResultsParser *xmlResultsParser;
        QStringList list;
	void setParams(QString params);
	bool firstlineOfParameters;
	bool stopByServer;
	bool newResults;
        QFile file;
        QString readMode;
        int fileSize;
        int bytesCount;
	QString getParams();
	void setSocket(QTcpSocket* tcpSocket);
	QTcpSocket* getSocket();
	int nbr;
        bool first;
public slots:
	void disconnectedClient();
	void stoppedByServer(int clientNbr);
	void readResults();
        void sendFirstContextToClient(QStringList list);
signals:
	void sendClientParametersToAddTab(QStringList parameters, int clientNbr);
        void sendClientContext(QStringList context, int clientNbr);
	void error(QString socketError);
        void sendResultsToDisplay(QString *results, int clientNbr);
        void removeClientTab(QString title, int clientNbr);
        void sendMessage(QString msg);
        void clientBytesSent(int bytesNbr, int fileSize);
        void endDownload(int clientNbr);
private:
	QString parameters;
	QTcpSocket *tcpSocket;
};

#endif
