/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "Client.h"

Client::Client(QTcpSocket *socket, int clientNbr, QObject *parent)
         : tcpSocket(socket), nbr(clientNbr), QObject(parent), file("./file.kop")
{
    first = true;
    setSocket(tcpSocket);
    xmlResultsParser = new XmlResultsParser(this);
    stopByServer = false;
    firstlineOfParameters = false;
    readMode = "xml";
    newResults = true;
    QObject::connect(xmlResultsParser, SIGNAL(sendFirstContextToClient(QStringList)), this, SLOT(sendFirstContextToClient(QStringList)));
    QObject::connect(socket, SIGNAL(disconnected()), this, SLOT(disconnectedClient()));
}

void Client::disconnectedClient()
{
    emit removeClientTab(getParams(), nbr);
}

void Client::stoppedByServer(int clientNbr)
{
    stopByServer = true;
    if (stopByServer)
    {
            if (clientNbr == nbr)
            {
                    getSocket()->disconnectFromHost();
                    getSocket()->close();
            }
    }
}

void Client::setSocket(QTcpSocket* qSocket)
{
    tcpSocket = qSocket;
}

QTcpSocket* Client::getSocket()
{
    return tcpSocket;
}

void Client::setParams(QString params)
{
    parameters = params;
}

QString Client::getParams()
{
    return parameters;
}

void Client::readResults()
{
    if (readMode == "file")
    {
        if(file.isOpen()==false)
        {
            if(!file.open(QIODevice::WriteOnly))
            {
                readMode = "xml";
                emit endDownload(nbr);
                emit sendMessage(tr("An error occured while getting remote file : The local file is not correctly opened."));
            }
        }
        int count = 0;
        while(tcpSocket->bytesAvailable() > 0)
        {
            if (bytesCount < fileSize)
            {
                file.write(tcpSocket->read(1));
                bytesCount++;
                count++;
                if (count > 2000) {
                    emit clientBytesSent(count, fileSize);
                    count = 0;
                }
                //qDebug() << tcpSocket->bytesAvailable() << " bytes left " << bytesCount << " bytes received";
            }
        }
        if (bytesCount == fileSize)
        {
            readMode = "xml";
            qDebug("CloseFile!");
            qDebug() << bytesCount << " bytes Total";
            emit endDownload(nbr);
            file.close();
            emit sendMessage(tr("File transfer succeeded.<br />This file is now available on the local computer at the path below : <br /><br />") + file.fileName());
            bytesCount = 0;
            return;
        }
    }
    else if (readMode == "xml")
    {
        while(tcpSocket->bytesAvailable() > 0)
        {
            QDataStream in(tcpSocket);
            QString resultat;
            quint16 c;
            int i = 0;
            while(tcpSocket->bytesAvailable() > 0)
            {
                if (tcpSocket->bytesAvailable() >= sizeof(quint16 ))
                {
                   in >> c;
                   char h = c;
                   //qDebug() << tcpSocket->bytesAvailable() << " (" << c << ") (" << h << ")";
                   if (i>1 && c != 0)
                      resultat+= c;
                   i++;
                   if (h == '\n')
                       break;
                }
            }
            qDebug() << "data " <<  resultat.size() <<" (" << resultat<< ")";
            if (firstlineOfParameters == false)
            {
                if (resultat.startsWith("<!DOCTYPE parameters>", Qt::CaseSensitive) && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
                {
                    readMode = "xml";
                    QStringList parameters = xmlResultsParser->getClientParametersFromXml(resultat);
                    qDebug(qPrintable("TEST" +resultat));
                    emit sendClientParametersToAddTab(parameters, nbr);
                    emit sendClientContext(xmlResultsParser->getList(), nbr);
                    firstlineOfParameters = true;
                } else {
                    tcpSocket->disconnectFromHost();
                    tcpSocket->close();
                    tcpSocket->waitForDisconnected();
                }
            } else
            {
                if (newResults == true)
                {
                    if (resultat.startsWith("<!DOCTYPE context>", Qt::CaseSensitive) && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
                    {
                        readMode = "xml";
                        newResults = false;
                        list = xmlResultsParser->parseXmlForCommandContext(resultat);
                        emit sendClientContext(list, nbr);
                    } else if (resultat.startsWith("<!DOCTYPE contextFile>", Qt::CaseSensitive) && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
                    {
                        readMode = "xml";
                        newResults = true;
                        list = xmlResultsParser->parseXmlForCommandContext(resultat);
                        emit sendClientContext(list, nbr);

                    } else if (resultat.startsWith("<!DOCTYPE fileTransfered>", Qt::CaseSensitive) && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
                    {
                        readMode = "xml";
                        newResults = true;
                        qDebug("File transfered from server to client result.");
                        QString transferedFile = xmlResultsParser->getFileTransferedOnRemoteClientfromXml(resultat);
                        if (transferedFile.startsWith( "FAILURE", Qt::CaseSensitive))
                            emit sendMessage(tr("File transfer failed.<br />An error occured while transfering file."));
                        else
                            emit sendMessage(tr("File transfer succeeded.<br />This file is now available on the remote workstation number ") + QString::number(nbr) + tr(" at the path below : <br /><br />") + transferedFile);
                    } else if (resultat.contains("fileAsked>", Qt::CaseSensitive) && resultat.contains("</" + QString(KONTROLPACK) + ">", Qt::CaseSensitive))
                    {
                        if (!resultat.contains("<!DOCTYPE fileAsked>", Qt::CaseSensitive))
                            if (resultat.startsWith("!DOCTYPE fileAsked>", Qt::CaseSensitive))
                                resultat = "<" + resultat;
                            if (resultat.startsWith("DOCTYPE fileAsked>", Qt::CaseSensitive))
                                resultat = "<!" + resultat;
                            if (resultat.startsWith("OCTYPE fileAsked>", Qt::CaseSensitive))
                                resultat = "<!D" + resultat;
                            if (resultat.startsWith("CTYPE fileAsked>", Qt::CaseSensitive))
                                resultat = "<!DO" + resultat;
                            if (resultat.startsWith("TYPE fileAsked>", Qt::CaseSensitive))
                                resultat = "<!DOC" + resultat;
                            if (resultat.startsWith("YPE fileAsked>", Qt::CaseSensitive))
                                resultat = "<!DOCT" + resultat;
                        QStringList askedFileList = xmlResultsParser->getFilePathFromXml(resultat);
                        readMode = "file";
                        newResults = true;
                        #ifdef WIN32
                            QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "\\KontrolPack\\Files/");
                            file.setFileName(kpDir.absolutePath() + "\\" + askedFileList.at(0));
                        #elif defined (linux)
                            QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files/");
                            file.setFileName(kpDir.absolutePath() + "/" + askedFileList.at(0));
                        #elif defined __APPLE__
                            QDir kpDir(QDir::toNativeSeparators(QDir::homePath()) + "/KontrolPack/Files/");
                            file.setFileName(kpDir.absolutePath() + "/" + askedFileList.at(0));
                        #endif
                        fileSize = askedFileList.at(1).toInt();
                        if (askedFileList.at(2) != NULL && askedFileList.at(2).startsWith("false", Qt::CaseSensitive))
                        {
                            readMode = "xml";
                            emit endDownload(nbr);
                            emit sendMessage(tr("You cannot read this file. Either check file permission or verify if the file exists."));
                            return;
                        }
                        if (fileSize > 50000000) {
                            readMode = "xml";
                            emit endDownload(nbr);
                            emit sendMessage(tr("This version does not allow to share files > 50Mo..."));
                            return;
                        } else
                        {
                            bool badlyOpened = false;
                            bytesCount = 0;
                            if(file.isOpen()==false)
                            {
                                if(!file.open(QIODevice::WriteOnly))
                                {
                                    readMode = "xml"; 
                                    emit sendMessage(tr("An error occured while getting remote file : The local file is not correctly opened."));
                                    emit endDownload(nbr);
                                    qDebug("File badly opened");
                                    badlyOpened = true;
                                }
                            }
                            emit sendMessage("DOWNLOADING");
                            int count = 0;
                            while(tcpSocket->bytesAvailable() > 0)
                            {
                                if (bytesCount < fileSize)
                                {
                                    file.write(tcpSocket->read(1));
                                    count++;
                                    if (count > 2000) {
                                        emit clientBytesSent(count, fileSize);
                                        count = 0;
                                    }
                                    bytesCount++;
                                }
                            }
                            if (bytesCount == fileSize && badlyOpened == false)
                            {
                                    readMode = "xml";
                                    qDebug("CloseFile!");
                                    qDebug() << bytesCount << " bytes Total";
                                    file.close();
                                    emit endDownload(nbr);
                                    emit sendMessage(tr("File transfer succeeded.<br />This file is now available on the local computer at the path below : <br /><br />") + file.fileName());
                                    bytesCount = 0;
                                    return;
                            }
                        }
                    }
                } else
                {
                    if (resultat.startsWith("####EXECUTED COMMAND####", Qt::CaseSensitive))
                    {
                        newResults = true;
                        readMode = "xml";
                        emit sendResultsToDisplay(new QString(resultat), nbr);
                    } else {
                        readMode = "xml";
                        emit sendResultsToDisplay(new QString(resultat), nbr);
                    }
                }
            }
        }
    }
}

void Client::sendFirstContextToClient(QStringList list)
{
    emit sendClientContext(list, nbr);
}
