/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "ClientMainWidget.h"

ClientMainWidget::ClientMainWidget()
{
    setWindowTitle(tr("KontrolPack : [TCP/IP Client Mode]"));
    QMenu *fileMenu = menuBar()->addMenu(tr("&File"));
    QMenu *shellMenu = menuBar()->addMenu(tr("&Shell"));
    QMenu *aboutMenu = menuBar()->addMenu(tr("&About"));
    aboutDialog = new AboutDialog();
	
    QAction *switchModeAction = fileMenu->addAction(tr("&Switch KontrolPack Mode Client/Server"));
    switchModeAction->setShortcut(QKeySequence("Ctrl+S"));
    switchModeAction->setIcon(QIcon(":/icons/go-jump.png"));

    QAction *quitAction = fileMenu->addAction(tr("&Quit"));
    quitAction->setShortcut(QKeySequence("Ctrl+Q"));
    quitAction->setIcon(QIcon(":/icons/exit.png"));

    QAction *startClientAction = shellMenu->addAction(tr("&Connect to server"));
    startClientAction->setShortcut(QKeySequence("Return"));
    startClientAction->setIcon(QIcon(":/icons/media-playback-start.png"));

    QAction *stopClientAction = shellMenu->addAction(tr("&Stop"));
    stopClientAction->setShortcut(QKeySequence("Return"));
    stopClientAction->setIcon(QIcon(":/icons/media-playback-stop.png"));

    QAction *aboutAction = aboutMenu->addAction(tr("&About"));
    aboutAction->setShortcut(QKeySequence("Ctrl+A"));
    aboutAction->setIcon(QIcon(":/icons/about.png"));

    setWindowIcon(QIcon(":/icons/kontrol-icon.png"));
    clientShell = new ClientShell;
    setCentralWidget(clientShell);

    QToolBar *fileToolBar = addToolBar(tr("Shell"));
    fileToolBar->addAction(startClientAction);
    fileToolBar->addAction(stopClientAction);
    fileToolBar->addAction(switchModeAction);
    fileToolBar->addSeparator();
     createActions();
     createTrayIcon();

     connect(trayIcon, SIGNAL(messageClicked()), this, SLOT(messageClicked()));
     connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
             this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));
    trayIcon->setIcon(QIcon(":/icons/kontrol-icon.png"));
    trayIcon->setToolTip(tr("KontrolPack: OPEN SOURCE NETWORK MANAGER."));
    QSystemTrayIcon::MessageIcon icon = QSystemTrayIcon::MessageIcon(1);
    trayIcon->showMessage(tr("KontrolPack"), tr("Remote Shell Command Executor"), icon,5000);
    trayIcon->show();
    connect(switchModeAction, SIGNAL(triggered()), this, SLOT(switchMode()));
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(displayAbout()));
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));
    connect(startClientAction, SIGNAL(triggered()), this, SLOT(startClient()));
    connect(stopClientAction, SIGNAL(triggered()), clientShell, SLOT(stopClient()));
    connect(clientShell, SIGNAL(hideUi()), this, SLOT(hide()));
}

void ClientMainWidget::startClient()
{
        hide();
        clientShell->connectToServer();
}

void ClientMainWidget::displayAbout()
{
        aboutDialog->exec();
}


 void ClientMainWidget::closeEvent(QCloseEvent *event)
 {
     if (trayIcon->isVisible()) {
         QMessageBox::information(this, tr("KontrolPack systray"),
                                  tr("KontrolPack will keep running in client mode into the "
                                     "system tray. To terminate the program, "
                                     "choose <b>Quit</b> in the context menu "
                                     "that pops up when clicking this program's "
                                     "entry in the system tray."));
         hide();
         event->ignore();
     }
 }


  void ClientMainWidget::iconActivated(QSystemTrayIcon::ActivationReason reason)
 {
     switch (reason) {
     case QSystemTrayIcon::Trigger:
     case QSystemTrayIcon::DoubleClick:
         qDebug("DoubleClick");
         break;
     case QSystemTrayIcon::MiddleClick:
         showMessage();
         break;
     default:
         ;
     }
 }


 void ClientMainWidget::createActions()
 {
     minimizeAction = new QAction(tr("Mi&nimize"), this);
     connect(minimizeAction, SIGNAL(triggered()), this, SLOT(hide()));

     restoreAction = new QAction(tr("&Restore"), this);
     connect(restoreAction, SIGNAL(triggered()), this, SLOT(showNormal()));

     quitAction = new QAction(tr("&Quit Client Mode"), this);
     connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));
 }

void ClientMainWidget::showMessage()
 {
     QSystemTrayIcon::MessageIcon icon = QSystemTrayIcon::MessageIcon();
     trayIcon->showMessage("KontrolPack", tr("Open Source Network Manager."), icon,
                           15 * 1000);
 }

 void ClientMainWidget::messageClicked()
 {
     QMessageBox::information(0, tr("KontrolPack"),
                              tr("Open Source Network Manager."));
 }


 void ClientMainWidget::createTrayIcon()
 {
     trayIconMenu = new QMenu(this);
     trayIconMenu->addAction(minimizeAction);
     trayIconMenu->addAction(restoreAction);
     trayIconMenu->addSeparator();
     trayIconMenu->addAction(quitAction);
     trayIcon = new QSystemTrayIcon(this);
     trayIcon->setContextMenu(trayIconMenu);
 }

void ClientMainWidget::switchMode()
{
	XmlDataStore::saveStartUpMode(QString("NONE"));
        QMessageBox::information(this, tr("Switch KontrolPack Mode Information"), tr("Your modification is saved. Please, restart KontrolPack in order to choose another mode."));
}
