/*******************************************************************************
**                        profilemanager.cpp
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// Qt includes
#include <qdatetime.h>

// KDE includes
#include <kmessagebox.h>
#include <klocale.h>

// My includes
#include "konservedebug.h"
#include "profilemanager.h"

////////////////////////////////////////////////////////////////////////////////
///////               class ProfileManager                               ///////
////////////////////////////////////////////////////////////////////////////////

ProfileManager::ProfileManager()
{
    TRACE();
    mProfileList.setAutoDelete( true );
}

ProfileManager::~ProfileManager()
{
    TRACE();
    // EVIL DIRTY UGLY HACK that shows that we do not have the right design
    BackupProfile *b;
    for ( b = mProfileList.first(); b; b = mProfileList.next() )
    {
        Subject::_evilHack_SaveBackupProfile( b );
    }
}

void ProfileManager::insertCalled( BackupProfile *b )
{
    TRACE();
    insertProfile( b );
}

void ProfileManager::changeCalled( BackupProfile *b )
{
    TRACE();
    changeProfile( b );
}
void ProfileManager::removeCalled( QString s )
{
    TRACE();
    removeProfile( s );
}

bool ProfileManager::existsCalled( QString s )
{
    TRACE();
    return 0L != getProfile( s );
}

void ProfileManager::restoreCalled( QString s )
{
    TRACE();
    getProfile( s )->restore();
}

void ProfileManager::activate()
{
    TRACE();
    BackupProfile *b;
    for ( b = mProfileList.first(); b; b = mProfileList.next() )
    {
        b->activate();
    }
}

void ProfileManager::slotDoBackup( QString identifier )
{
    TRACE();
    Q_ASSERT( existsCalled( identifier )  );

    getProfile( identifier )->slotDoOneTimeBackup();
}

void ProfileManager::insertProfile( BackupProfile *bp )
{
    TRACE();
    kdDebug(0) << "ProfileManager::insertProfile" << endl;
    kdDebug(0) << "Identifier: " << bp->getIdentifier() << endl;
    kdDebug(0) << "Source url: " << bp->getSourceUrl().url() << endl;
    kdDebug(0) << "Archive url: " << bp->getArchiveUrl().url() << endl;
    kdDebug(0) << "TimerInterval url: " << bp->getTimeBetweenBackups().secs()
               << " secs" << endl;
    kdDebug(0) << "Last backup: " << bp->getLastTime().toString() << endl;

    if ( 0L != getProfile( bp->getIdentifier() ) )
        changeProfile( bp );
    else
        newProfile( bp );

    bp->activate();
    return;
}

void ProfileManager::newProfile( BackupProfile *bp )
{
    TRACE();
    Q_ASSERT( 0L == getProfile( bp->getIdentifier() ) );

    Q_CHECK_PTR( bp );
    mProfileList.append( bp );
}

void ProfileManager::changeProfile( BackupProfile *bp )
{
    TRACE();
    Q_ASSERT( 0L != getProfile( bp->getIdentifier() ));

    int index = mProfileList.find( getProfile( bp->getIdentifier() ) );
    mProfileList.remove( index );
    mProfileList.insert( index, bp );
}

void ProfileManager::removeProfile( QString id )
{
    TRACE();
    const BackupProfile * const b = getProfile( id );
    if ( 0L == (long int) b )
    {
        KMessageBox::error(
            0L,
            i18n( "Sorry, could not remove profile: %1.\n"
                  "The Identifier is not in the list" ).arg( id )
            );
        return;
    }

    int index = mProfileList.find( b );
    Q_ASSERT( -1 != index );

    if ( !mProfileList.remove( index ) )
        Q_ASSERT( false );
}

BackupProfile* ProfileManager::getProfile( QString id )
{
    TRACE();
    BackupProfile *b      = 0L;
    BackupProfile *result = 0L;

    for ( b = mProfileList.first(); b; b = mProfileList.next() )
    {
        if ( id == b->getIdentifier() )
        {
            if ( 0L != result )
                Q_ASSERT( false ); // Consistency check, no Identifier twice
            result = b;
        }
    }
    return result;
}

#include "profilemanager.moc"
