/*******************************************************************************
**                              konserve.h
**                                part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef KONSERVE_H
#define KONSERVE_H

// KDE includes
#include <kmainwindow.h>
#include <kaboutapplication.h>

// My includes
#include "profilemanager.h"
#include "configurator.h"
#include "systemtraywidget.h"
#include "configurationdlg.h"
#include "wizard.h"

////////////////////////////////////////////////////////////////////////////////
///////                  class Konserve                                  ///////
////////////////////////////////////////////////////////////////////////////////

class Konserve : public KMainWindow
{
    Q_OBJECT

public:
    Konserve();
    ~Konserve();

public slots:
    void slotQuit();

private:
    void contructMembers();
    void setupConnections();

private:
    ProfileManager     *mpTheProfileManager;
    SystemTrayWidget   *mpTheWidget;
    ConfigurationDlg   *mpTheConfigDlg;
    Wizard             *mpTheWizard;
    Configurator       *mpTheConfigurator;
    KAboutApplication  *mpKAboutApp;
};

#endif
