#!/usr/bin/perl

# Library for Konqueror Plus ver.0.1.1
# 
# Copyright (c) 1999-2000 Japan KDE Users' Group
# 
# All rights reserved.
# 
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, and/or sell copies of the Software, and to permit persons
# to whom the Software is furnished to do so, provided that the above
# copyright notice(s) and this permission notice appear in all copies of
# the Software and that both the above copyright notice(s) and this
# permission notice appear in supporting documentation.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
# OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
# HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
# INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

## 使用例一覧
# 
# lowercase("AbCDeFG") → "abcdefg"
# uppercase("AbCDeFG") → "ABCDEFG"
# 
# dirname("/usr/local/etc/abc.txt") → "/usr/local/etc"
# basename("/usr/local/etc/abc.txt") → "abc.txt"
# 
# getext("abc.txt") → "txt"
# rmext("abc.txt") → "abc"
# 
# homedir() → "/home/user"
# 
# openKonq("/usr/local");
# 
# writekprc();


## 初期設定
#
# ~/.kde/share/config/konqplusrc を %KPRC に読み込む

$resfile = &homedir . "/.kde/share/config/konqplusrc";
if(open(FILE, $resfile)){
  @kprc = <FILE>;
  close(FILE);
  foreach(@kprc){
    chop;
    ($kprc1, $kprc2) = split(/=/);
    $KPRC{$kprc1} = $kprc2 if $kprc2 ne "";
  }
}
return 1;


## アルファベットを小文字にする
#
# 引数: 文字列
# 戻値: 文字列
# (例) lowercase("AbCDeFG") → "abcdefg"

sub lowercase
{
  local($a) = $_[0];
  $a =~ s/([A-Z])/\l$1/g;
  return $a;
}

## アルファベットを大文字にする
#
# 引数: 文字列
# 戻値: 文字列
# (例) uppercase("AbCDeFG") → "ABCDEFG"

sub uppercase
{
  local($a) = $_[0];
  $a =~ s/([a-z])/\u$1/g;
  return $a;
}


## パス取得
#
# 引数: フルパス
# 戻値: パス
# (例) dirname("/usr/local/etc/abc.txt") → "/usr/local/etc"

sub dirname
{
  local($a) = $_[0];
  $a = `dirname $a`;
  chop $a;
  return $a;
}

## ファイル名取得
#
# 引数: フルパス
# 戻値: ファイル名
# (例) basename("/usr/local/etc/abc.txt") → "abc.txt"

sub basename
{
  local($a) = $_[0];
  $a = `basename $a`;
  chop $a;
  return $a;
}


## 拡張子を取り出す
#
# 引数: ファイル名
# 戻値: 拡張子
# (例) getext("abc.txt")     → "txt"
#      getext("abc.tar.gz")  → "tar.gz"
#      getext("abc.tar.bz2") → "tar.bz2"
#      getext("abc.tar.Z")   → "tar.Z"
#      getext("abc.def.txt") → "txt"

sub getext
{
  local($a) = $_[0];
  if($a !~ /\./){
    $a = "";
  }elsif($a =~ /\.tar\.gz$/){
    $a = "tar.gz";
  }elsif($a =~ /\.tar\.bz2$/){
    $a = "tar.bz2";
  }elsif($a =~ /\.tar\.Z$/){
    $a = "tar.Z";
  }else{
    $a =~ s/.*\.(.*)$/$1/;
  }
  return $a;
}

## 拡張子を取り除く
#
# 引数: ファイル名
# 戻値: 拡張子を取り除いたファイル名
# (例) rmext("abc.txt")     → "abc"
#      rmext("abc.tar.gz")  → "abc"
#      rmext("abc.tar.bz2") → "abc"
#      rmext("abc.tar.Z")   → "abc"
#      rmext("abc.def.txt") → "abc.def"

sub rmext
{
  local($a) = $_[0];
  local($b) = &getext($a);
  if($b =~ /\./){
    $a =~ s/(.*)\..*\..*$/$1/;
  }else{
    $a =~ s/(.*)\..*$/$1/;
  }
  return $a;
}


## ホームディレクトリ取得
#
# 引数: なし
# 戻値: ホームディレクトリ
# (例) homedir() → "/home/user"

sub homedir
{
  local($a) = $ENV{"HOME"};
  $a =~ s/\/$//;
  return $a;
}


## Konqueror を開く
#
# 引数: 開くパス
# 戻値: なし
# (例) openKonq("/usr/local");

sub openKonq
{
  local($a) = $_[0];
  $a =~ s/\/$//;
  `kfmclient openURL $a`;
}


## リソース書き込み
#
# 引数: なし
# 戻値: なし
# (例) writekprc();

sub writekprc
{
  local($a);
  if(open(FILE, ">$resfile")){
    foreach $a(sort keys %KPRC){
      print FILE "$a=$KPRC{$a}\n" if $KPRC{$a} ne "";
    }
    close(FILE);
  }
}
