/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kompile.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <qfile.h>

static const char description[] =
    I18N_NOOP("KDE Frontend for automated source packages installation/uninstallation");

static const char version[] = "0.2";

static KCmdLineOptions options[] =
{
    { "uninstall", I18N_NOOP( "Uninstall package" ), "" },    
    { "+FILE", I18N_NOOP( "Sources tarball to install" ), "" },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kompile", I18N_NOOP("Kompile"), version, description,
                     KAboutData::License_GPL, "(C) 2005 Tommaso Frazzetto", 0, 0, "tommaso.frazzetto@gmail.com");
    about.addAuthor( "Tommaso Frazzetto", 0, "tommaso.frazzetto@gmail.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    Kompile *mainWin = 0;

    if (app.isRestored())
    {
        //RESTORE(Kompile);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        
        int op = Kompile::OPERATION_INSTALL;

        if (args->isSet("uninstall"))
            op = Kompile::OPERATION_UNINSTALL;

 
        /// @todo do something with the command line args here
        QString * file = new QString("");        
        if (args->count() > 0)
            file = new QString(args->arg(args->count() - 1));

        mainWin = new Kompile(*file, op, true);
        delete file;
        app.setMainWidget( mainWin );
        mainWin->show();
        mainWin->startInstallation();
        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

