/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlabel.h>
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qprocess.h>
#include <qpoint.h>
#include <qprogressbar.h>
#include <qdir.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qbuttongroup.h>
#include <qdialog.h>
#include <qtimer.h>
#include <qcheckbox.h>

#include <kglobal.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kaboutapplication.h>
#include <kuser.h>
#include <kmessagebox.h>

#include "kompilewidget.h"
#include "kompileuserinstall.h"
#include "kompile.h"

#include <stdlib.h>

KompileWidget::KompileWidget(QString& tarball, bool uninstall, QWidget* parent, const char* name, WFlags fl)
        : KompileWidgetBase(parent,name,fl)
{
    this->do_uninstall = uninstall;
    this->parent = (Kompile *) parent;
    this->tarball = tarball;
    this->step = 0;
    this->timer = NULL;
    pbProgress->setProgress(0);

    pxmInstallation->setPixmap(KGlobal::iconLoader()->loadIcon("kpackage", KIcon::Desktop, 128));    
    pxmDecompress->setPixmap(KGlobal::iconLoader()->loadIcon("ark", KIcon::MainToolbar, 22, KIcon::DisabledState));
    pxmConfigure->setPixmap(KGlobal::iconLoader()->loadIcon("configure", KIcon::MainToolbar, 22, KIcon::DisabledState));
    btnAbort->setPixmap(KGlobal::iconLoader()->loadIcon("cancel", KIcon::MainToolbar));
    btnDetails->setPixmap(KGlobal::iconLoader()->loadIcon("2rightarrow", KIcon::MainToolbar));
   
    KUser * whoami = new KUser();
    installation_type = KompileUserInstall::FORCECONTINUE;
    if (!whoami->isSuperUser()) 
    {
        KompileUserInstall * user_install = new KompileUserInstall( this );
        user_install->setModal(TRUE);
        user_install->exec();
        txtConsole->setText(txtConsole->text() + "User isn't able to install. Need more privilegies...<br>");

        if (user_install->result() == QDialog::Rejected) 
        {
            exit(-1);
        }
        
        installation_type = user_install->getInstallationMethod();
        if (installation_type == KompileUserInstall::USERINSTALLATION) 
            user_dir = user_install->getInstallationDirectory();
        
        if (installation_type == 0)
                txtConsole->setText(txtConsole->text() + "Perform super user installation (Ask user root password)...<br>");
        else if (installation_type == 1)
                txtConsole->setText(txtConsole->text() + "Perform super user installation (Probably get installation error)...<br>");
         else
         {
                txtConsole->setText(txtConsole->text() + "Perform simple user installation (Ask user writable destination directory)...<br>");
                lblTaskStatus->setText("<b>Installation steps (simple user)</b>:");
         }
                
        delete user_install;
    }

    delete whoami;
    
    if (!do_uninstall)
    {
        pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("make_kdevelop", KIcon::MainToolbar, 22, KIcon::DisabledState));
        pxmInstall->setPixmap(KGlobal::iconLoader()->loadIcon("exec", KIcon::MainToolbar, 22, KIcon::DisabledState));
        if (installation_type == KompileUserInstall::USERINSTALLATION)
            lblTaskStatus->setText("<b>Installation steps (simple user)</b>:");
        else
            lblTaskStatus->setText("<b>Installation steps (super user)</b>:");
    }
    else
    {
        pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::MainToolbar, 22, KIcon::DisabledState));
        pxmInstall->hide();
        lblMakeInstall->hide();
        lblMake->setText("Uninstall binaries");
        QToolTip::add(btnAbort, "Abort uninstallation");
        gbProgress->setTitle("Total Uninstallation Progress");
        pbProgress->setTotalSteps(75);
        if (installation_type == KompileUserInstall::USERINSTALLATION)
            lblTaskStatus->setText("<b>Uninstallation steps (simple user)</b>:");
        else
            lblTaskStatus->setText("<b>Uninstallation steps (super user)</b>:");
    }

    QStringList tokens = QStringList::split("/", tarball);
    parent->setCaption(tokens[tokens.count() - 1]);
}

KompileWidget::~KompileWidget()
{    
    delete process;
    if (timer != NULL)
        delete timer;

}

void KompileWidget::btnDetails_clicked()
{
    if (height() == 220) 
    {
        btnDetails->setTextLabel("Hide &Details");
        QToolTip::add(btnDetails, "Hide console output");
        btnDetails->setPixmap(KGlobal::iconLoader()->loadIcon("2leftarrow", KIcon::MainToolbar));

        parent->setFixedHeight(410);
    }
    else
    {
        btnDetails->setTextLabel("Show &Details");
        QToolTip::add(btnDetails, "Show console output");
        btnDetails->setPixmap(KGlobal::iconLoader()->loadIcon("2rightarrow", KIcon::MainToolbar));

        parent->setFixedHeight(220);
    }
}


void KompileWidget::compileAndInstall() 
{
    step = 1;
    pxmArrow->setPixmap(KGlobal::iconLoader()->loadIcon("1rightarrow", KIcon::MainToolbar));

    if (!do_uninstall)
        txtConsole->setText(txtConsole->text() + "Start <b>'" + tarball + "'</b> installation...<br>");
    else
        txtConsole->setText(txtConsole->text() + "Start <b>'" + tarball + "'</b> uninstallation...<br>");
    
    decompress();
}


void KompileWidget::decompress()
{    
    txtConsole->setText(txtConsole->text() + "Decompression of source tarball...<br>");
    lblDecompress->setText("<b>Decompress archive</b>");
    parent->setTrayiconTooltip("Installation Step: <i>Decompression</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
    pxmDecompress->setPixmap(KGlobal::iconLoader()->loadIcon("ark", KIcon::MainToolbar));    
    
    this->process = new QProcess( this );

    connect( process, SIGNAL(readyReadStdout()), this, SLOT(processReadFromStdout()));    
    connect( process, SIGNAL(readyReadStderr()), this, SLOT(processReadFromStderr()));    
    connect( process, SIGNAL(processExited()), this, SLOT(processExited()));    

    QDir * dir = new QDir();
    dir->mkdir("/tmp/kompile-tmp/");
    delete dir;

    process->addArgument("/bin/tar");
    process->addArgument("-x");
    process->addArgument("-v");
    if (tarball.endsWith(".gz"))
        process->addArgument("-z");
    else if (tarball.endsWith(".bz2"))
        process->addArgument("-j");

    process->addArgument("-f");
    process->addArgument(tarball);
    process->addArgument("-C");
    process->addArgument("/tmp/kompile-tmp/");

    
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
    QStringList list = process->arguments();

    for (int index = 0; index < list.count(); index++) {
        txtConsole->setText(txtConsole->text() + list[index] + " ");
    }

    txtConsole->setText(txtConsole->text() + "</font><br>");
    pbProgress->setProgress(12);
    parent->setTrayiconTooltip("Installation Step: <i>Decompression</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");

    if (!process->start()) 
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Can't start archive decompression.</font>" + "<br>");
    }
}

void KompileWidget::configure()
{
    step = 2;
    txtConsole->setText(txtConsole->text() + "Configuring sources...<br>");    
    lblConfigure->setText("<b>Configuring sources</b>");
    parent->setTrayiconTooltip("Installation Step: <i>Configuration</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
    pxmConfigure->setPixmap(KGlobal::iconLoader()->loadIcon("configure", KIcon::MainToolbar));    
    QPoint arrow_pos = pxmArrow->pos();
    arrow_pos.setY(arrow_pos.y() + 22);
    pxmArrow->move(arrow_pos);

    QDir * dir = new QDir("/tmp/kompile-tmp/");
    QStringList entries = dir->entryList();
    QString path = "/tmp/kompile-tmp/" + entries[entries.count() - 1] + "/";
    if (!dir->setCurrent(path))
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable to change current path.<br>Installation aborted!</font><br>");
        KMessageBox::error(this, "Kompile is unable to change current path to application's sources folder.\nYou should try to manually enter into sources folder '" + path + "' and type:\n~]# ./configure && make && make install.\nInstallation failed", "Installation failed");
        step = 6;
        return;
    }

    txtConsole->setText(txtConsole->text() + "Moved to " + dir->current().path() + "<br>");    
    
    if (dir->entryList().find("configure") == entries.end())
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable to find configuration script.<br>Package compiling my require particular compilation procedure. You should try compile package manually.<br>Installation failed!</font><br>");
        KMessageBox::error(this, "Kompile is unable to find the configuration script in the application's sources folder.\n.Package compiling my require particular compilation procedure. You should try to compile sources manually.\nInstallation failed!", "Installation failed");
        step = 6;
        btnAbort->setTextLabel("&Close"); 
    }
    delete dir;

    delete process;
    this->process = new QProcess( );

    connect( process, SIGNAL(readyReadStdout()), this, SLOT(processReadFromStdout()));    
    connect( process, SIGNAL(readyReadStderr()), this, SLOT(processReadFromStderr()));    
    connect( process, SIGNAL(processExited()), this, SLOT(processExited()));    

    process->addArgument("/bin/sh");
    process->addArgument("configure");

    if (installation_type == KompileUserInstall::USERINSTALLATION) 
    {
        process->addArgument("--prefix=" + user_dir);
    }

    txtConsole->setText(txtConsole->text() + "Configuring sources...<br>");
    
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
    QStringList list = process->arguments();

    for (int index = 0; index < list.count(); index++) {
        txtConsole->setText(txtConsole->text() + list[index] + " ");
    }

    txtConsole->setText(txtConsole->text() + "</font><br>");
    if (!process->start()) 
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable to start sources configuration..</font>" + "<br>");
    }
   
}

void KompileWidget::make()
{
    step = 3;
    txtConsole->setText(txtConsole->text() + "Building sources...<br>");    
    lblMake->setText("<b>Building sources</b>");
    parent->setTrayiconTooltip("Installation Step: <i>Building</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
    pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("make_kdevelop", KIcon::MainToolbar));    
    QPoint arrow_pos = pxmArrow->pos();
    arrow_pos.setY(arrow_pos.y() + 22);
    pxmArrow->move(arrow_pos);

    delete process;
    this->process = new QProcess( );

    connect( process, SIGNAL(readyReadStdout()), this, SLOT(processReadFromStdout()));    
    connect( process, SIGNAL(readyReadStderr()), this, SLOT(processReadFromStderr()));    
    connect( process, SIGNAL(processExited()), this, SLOT(processExited()));    

    process->addArgument("/usr/bin/make");
   
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
    QStringList list = process->arguments();

    for (int index = 0; index < list.count(); index++) {
        txtConsole->setText(txtConsole->text() + list[index] + " ");
    }

    txtConsole->setText(txtConsole->text() + "</font><br>");
    if (!process->start()) 
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable build sources.</font>" + "<br>");
    }
}

void KompileWidget::install()
{
    step = 4;
    txtConsole->setText(txtConsole->text() + "Installing binaries...<br>");    
    lblMakeInstall->setText("<b>Installing bineries</b>");    
    parent->setTrayiconTooltip("Installation Step: <i>Installing</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
    pxmInstall->setPixmap(KGlobal::iconLoader()->loadIcon("exec", KIcon::MainToolbar));    
    QPoint arrow_pos = pxmArrow->pos();
    arrow_pos.setY(arrow_pos.y() + 22);
    pxmArrow->move(arrow_pos);

    delete process;
    this->process = new QProcess( );

    connect( process, SIGNAL(readyReadStdout()), this, SLOT(processReadFromStdout()));    
    connect( process, SIGNAL(readyReadStderr()), this, SLOT(processReadFromStderr()));    
    connect( process, SIGNAL(processExited()), this, SLOT(processExited()));    

    
    if (installation_type == KompileUserInstall::REQUESTROOOTPASSWORD) 
    {
        process->addArgument(KStandardDirs::findExe("kdesu"));
    }
        
    process->addArgument("/usr/bin/make");
    process->addArgument("install");
   
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
    QStringList list = process->arguments();

    for (int index = 0; index < list.count(); index++) {
        txtConsole->setText(txtConsole->text() + list[index] + " ");
    }

    txtConsole->setText(txtConsole->text() + "</font><br>");
    if (!process->start()) 
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable to install bineries.</font>" + "<br>");
    }
}

void KompileWidget::uninstall()
{
    step = 10;
    txtConsole->setText(txtConsole->text() + "Uninstalling binaries...<br>");    
    lblMake->setText("<b>Uninstalling bineries</b>");    
    parent->setTrayiconTooltip("Uninstalling Step: <i>Uninstalling</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
    pxmMake->setPixmap(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::MainToolbar));    
    QPoint arrow_pos = pxmArrow->pos();
    arrow_pos.setY(arrow_pos.y() + 22);
    pxmArrow->move(arrow_pos);

    delete process;
    this->process = new QProcess( );

    connect( process, SIGNAL(readyReadStdout()), this, SLOT(processReadFromStdout()));    
    connect( process, SIGNAL(readyReadStderr()), this, SLOT(processReadFromStderr()));    
    connect( process, SIGNAL(processExited()), this, SLOT(processExited()));    

    if (installation_type == KompileUserInstall::REQUESTROOOTPASSWORD) 
    {
        process->addArgument(KStandardDirs::findExe("kdesu"));
    }

    process->addArgument("/usr/bin/make");
    process->addArgument("uninstall");
   
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>");
    QStringList list = process->arguments();

    for (int index = 0; index < list.count(); index++) {
        txtConsole->setText(txtConsole->text() + list[index] + " ");
    }

    txtConsole->setText(txtConsole->text() + "</font><br>");
    if (!process->start()) 
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable to uninstall bineries.</font>" + "<br>");
    }
}

void KompileWidget::processReadFromStdout()
{
    QString string = process->readLineStdout();

    if (!string.isEmpty()) {
        txtConsole->setText(txtConsole->text() + string + "<br>");
    }
}

void KompileWidget::processReadFromStderr()
{
    QString string = process->readLineStderr();

    if (!string.isEmpty()) {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>" + string + "</font>" + "<br>");
    }
}

bool KompileWidget::removeSources()
{ 
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>Remove source directory...</font><br>");
    process->clearArguments();

    process->addArgument("/bin/rm");
    process->addArgument("-fvr");
    process->addArgument("/tmp/kompile-tmp");

    if (!process->start()) 
    {
        txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Unable to remove source directory...</font><br>");
        return FALSE;
    }
    
    txtConsole->setText(txtConsole->text() + "<font color=#6666AA>Source directory removed.</font><br>");
    return TRUE;
}

void KompileWidget::processExited()
{
    QString op_string("Installation");

    if (do_uninstall)
        QString op_string("Uninstallation");

    switch (step) 
    {
        case 1:
            if (!process->normalExit() || process->exitStatus() != 0 || process->exitStatus() != 0) 
            {
                txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Error during archive decompression. " + op_string + " aborted!</font>" + "<br>");
                KMessageBox::error(this, "Kompile is unable to decompress archive.\n You should try to decompress archive and compile sources manually.\n" + op_string + " failed!", op_string + " failed");
                step = 6;
                btnAbort->setTextLabel("&Close"); 

                return;
            }
    
            txtConsole->setText(txtConsole->text() + "<font color=#66AA66>Archive decompressed.</font><br>");
            pbProgress->setProgress(25);
            lblDecompress->setText("Archive decompressed");
            configure();
        break;
        case 2:
            if (!process->normalExit() || process->exitStatus() != 0) 
            {
                txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Error during sources configuration. " + op_string + " aborted!</font>" + "<br>");
                KMessageBox::error(this, "Kompile is unable to start sources configuration.\n You should try to compile sources manually.\n" + op_string + " failed!", op_string + " failed");
                step = 6;
                btnAbort->setTextLabel("&Close"); 
                
                return;
            }
    
            txtConsole->setText(txtConsole->text() + "<font color=#66AA66>Sources configured.</font><br>");
            pbProgress->setProgress(50);
            lblConfigure->setText("Sources configured");            
            if (do_uninstall)
                uninstall();
            else
                make();
        break;
        case 3:
            if (!process->normalExit() || process->exitStatus() != 0) 
            {
                txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Error during source build. " + op_string + " aborted!</font>" + "<br>");
                KMessageBox::error(this, "Kompile is unable to start sources building.\n You should try to compile sources manually.\n" + op_string + " failed!", op_string + " failed");    
                step = 6;
                btnAbort->setTextLabel("&Close"); 

                return;
            }
    
            txtConsole->setText(txtConsole->text() + "<font color=#66AA66>Sources builded.</font><br>");
            pbProgress->setProgress(75);
            lblMake->setText("Sources builded");
            install();
        break;
        case 4:
            if (!process->normalExit() || process->exitStatus() != 0) 
            {
                txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Error binaries installation. " + op_string + " aborted!</font>" + "<br>");
                KMessageBox::error(this, "Kompile is unable to start binary installation.\n You should try to compile and install sources manually.\n" + op_string + " failed!", op_string + " failed");    
                step = 6;
                btnAbort->setTextLabel("&Close"); 

                return;
            }
    
            txtConsole->setText(txtConsole->text() + "<font color=#66AA66>Binaries installed.</font><br>");
            pbProgress->setProgress(100);
            parent->setTrayiconTooltip("" + op_string + " Step: <i>Finish</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
            btnAbort->setTextLabel("&Finish");
            QToolTip::add(btnAbort, "Close Kompile");

            btnAbort->setPixmap(KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
            step = 5;
            lblMakeInstall->setText("Binaries installed");
            if (chkAutoclose->isChecked()) 
            {
                timer = new QTimer();
                seconds_left = 20;
                connect(timer, SIGNAL(timeout()), this, SLOT(autoclose_timeout()));
                chkAutoclose->setText("Kompile close in 20s");
                timer->start(1000);
            }
            else
                chkAutoclose->hide();

        break;
        case 10:
            if (!process->normalExit() || process->exitStatus() != 0) 
            {
                txtConsole->setText(txtConsole->text() + "<font color=#AA6666>Error binaries uninstallation. " + op_string + " aborted!</font>" + "<br>");
                KMessageBox::error(this, "Kompile is unable to start binary uninstallation.\n You should try to uninstall sources manually.\n" + op_string + " failed!", op_string + " failed");    
                step = 6;
                btnAbort->setTextLabel("&Close"); 

                return;
            }
    
            txtConsole->setText(txtConsole->text() + "<font color=#66AA66>Binaries uninstalled.</font><br>");
            pbProgress->setProgress(75);
            parent->setTrayiconTooltip("" + op_string + " Step: <i>Finish</i><br>Total Progress: <i>" + pbProgress->progressString() + "</i>");
            btnAbort->setTextLabel("&Finish");
            QToolTip::add(btnAbort, "Close Kompile");

            btnAbort->setPixmap(KGlobal::iconLoader()->loadIcon("ok", KIcon::MainToolbar));
            step = 5;
            lblMake->setText("Binaries uninstalled");
            if (chkAutoclose->isChecked()) 
            {
                timer = new QTimer();
                seconds_left = 20;
                connect(timer, SIGNAL(timeout()), this, SLOT(autoclose_timeout()));
                chkAutoclose->setText("Kompile close in 20s");
                timer->start(1000);
            }
            else
                chkAutoclose->hide();


        break;
    }
}

void KompileWidget::txtConsole_textChanged()
{
    txtConsole->scrollToBottom();
}

void KompileWidget::btnAbort_clicked()
{
    if (step == 5) 
    {
        if (!removeSources())
            KMessageBox::detailedSorry(this, "Unable to remove source temporary directory.\nYou should try to remove directory manually. Open terminal and type:\n~]#rm -fvr /tmp/kompile-tmp/", "Warning");
            
        exit(0);
    }
    else if (step == 6) 
    {
        if (!removeSources())
            if (!removeSources()) 
                KMessageBox::detailedSorry(this, "Unable to remove source temporary directory.\nYou should try to remove directory manually. Open terminal and type:\n~]#rm -fvr /tmp/kompile-tmp/", txtConsole->text(), "Warning");
        exit(-1);
    }
    else
    {
        if (KMessageBox::warningYesNo(this, "Installation of '" + tarball + "' isn't completed'.\nAre you sure you want abort installation and lost all buildings steps already done?", "Abort") == KMessageBox::Yes) 
        {
            if (!removeSources()) 
                KMessageBox::detailedSorry(this, "Unable to remove source temporary directory.\nYou should try to remove directory manually. Open terminal and type:\n~]#rm -fvr /tmp/kompile-tmp/", txtConsole->text(), "Warning");
            
            exit(-2);
        } 
    }
}

void KompileWidget::btnAbout_clicked()
{
	KAboutApplication about( this );
	about.exec();
}

void KompileWidget::autoclose_timeout()
{
    seconds_left--;
    if (seconds_left == 0)
    {
        disconnect(timer, SIGNAL(timeout()), this, SLOT(autoclose_timeout()));
        btnAbort_clicked();
    }
    
    QString * seconds = new QString();
    chkAutoclose->setText("Kompile close in " + seconds->setNum(seconds_left) + "s");
    delete seconds;
}




#include "kompilewidget.moc"

