/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CONFIGDIALOGIMPL_H
#define CONFIGDIALOGIMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "configdialog.h"

#include <qptrlist.h>

#include "kommandoview.h"

class KService;
class KServiceGroup;
class KShortcut;

/**
 * @short Application Main Window
 * @author Daniel Stöckel <the_docter@gmx.net>
 * @version 0.5.0
 */

class ConfigDialogImpl : public ConfigDialog
{
    Q_OBJECT

    public:
        ConfigDialogImpl(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
        /*$PUBLIC_FUNCTIONS$*/
        void readConfig();

    public slots:
        virtual void slotDefaultsClicked();
        virtual void slotApplyClicked();

    signals:
        void changed(bool);

    protected:
        bool configChanged;
        bool grabbing;
        KommandoView* curListView;
        KommandoViewList mMenus;

        /*$PROTECTED_FUNCTIONS$*/

        virtual void initView();
        virtual void listViewFromClick();
        void createEntry(const QString& kind);  //This is a helper function to add a new entry to the Listview
        void setChanged(bool state);
        bool event(QEvent* evt);
    protected slots:
        /*$PROTECTED_SLOTS$*/
        virtual void slotChangeListView(const QString&);
        virtual void slotButtonUpPressed();
        virtual void slotButtonDownPressed();
        virtual void slotCustomSizeCheckboxToggled(bool);
        virtual void slotSchemeComboboxChanged(const QString&);
        virtual void slotMenuRadiusSpinboxChanged(int);
        virtual void slotShortcutChanged(const KShortcut& cut);
        virtual void slotCommandoTyped(const QString& commando);
        virtual void slotMenuViewClicked(QListViewItem* item);
        virtual void slotNewIcon();
        virtual void slotRemoveClicked();
        virtual void slotAddButtonClicked();
        virtual void slotAddMenuClicked();
        virtual void slotListBoxClicked(QListBoxItem* item);
        virtual void slotColorButtonClicked(const QColor& color);
        virtual void slotOpacitySliderChanged(int value);
        virtual void slotNavButtonSizeChanged(const QString&);
        virtual void slotMenuButtonSizeChanged(const QString&);
        virtual void slotAddService(KService* service);
        virtual void slotAddServiceGroup(KServiceGroup* group);
        virtual void slotRemoveListViewClicked();
        virtual void slotNewListViewClicked();
};

#endif



