/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel   *
 *   the_docter@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MENULISTVIEWITEM_H
#define MENULISTVIEWITEM_H

#include <qlistview.h>
#include <qdom.h>

class MenuListViewItem : public QListViewItem
{
	public:
		enum ItemType{Menu,Button};
		
		MenuListViewItem(QListViewItem* parent, QString col1, ItemType type=Button, QString iconPath=NULL, QString col2=NULL);
		MenuListViewItem(QListView* parent, QString col1, ItemType type=Button, QString iconPath=NULL, QString col2=NULL);

    ~MenuListViewItem();

		void setType(const ItemType icontype){ mType = icontype; }
		ItemType type() const{ return mType; }

		void setIcon(const QString& path);
		QString iconPath() const { return mIconPath; }

		void toXML(QDomDocument& doc, QDomElement& parent);
		void fromXML(const QDomElement& ownNode);

	protected:
		ItemType mType;
		QString mIconPath;
};

#endif
