/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#define PI 3.14159265
 
#include "menu.h"
#include "commandobutton.h"
#include "constants.h"

#include <math.h>

Menu::Menu(Menu* parentMenu)
	: QButtonGroup(),mParentMenu(parentMenu),mSelectedButtonNum(BUTTON_DESELECT)
{
	children.setAutoDelete(true);
}


Menu::~Menu()
{
	for(int i=0;i<count();++i)
	{
		QButton* temp = find(i);
		remove(temp);
		delete temp;
	}
}

void Menu::showButtons( )
{
	//QRegion temp;
	CommandoButton* button;
	for(int i=0;i<count();++i)
	{
		button=static_cast<CommandoButton*>(find(i));
		button->show();
		//temp+=button->mask();
	}
	//return temp;
}

void Menu::arrangeButtons( )
{
	CommandoButton* button;
	double step=2*PI/static_cast<double>(count());
	for(int i=0;i<count();++i){
		button=static_cast<CommandoButton*>(find(i));
		//God bless sine and cosine
		button->move(static_cast<int>(sin(i*step)*MENU_RADIUS+WINDOW_CENTER),static_cast<int>(-cos(i*step)*MENU_RADIUS+WINDOW_CENTER));
	}
}

void Menu::hideButtons( )
{
	for(int i=0;i<count();++i)
	{
		find(i)->hide();
	}
}

void Menu::addChild( Menu * menu )
{
	children.append(menu);
}

void Menu::fromXML(const QDomElement& ownNode, QWidget* buttonParent)
{
	QString iconpath;
	QString command;
	QDomNode node=ownNode.firstChild();
	
	while(!node.isNull()){
		if(node.isElement()){
			ExtendedButton* button;
			if(node.nodeName() == "button"){
				button = new CommandoButton(buttonParent,node.toElement());
				insert(button);
			} else if(node.nodeName()=="menu"){
				Menu* subMenu = new Menu(this);												//establish all necessary connections, e.g. menu structure
				button = new SubmenuButton(buttonParent,subMenu);
				insert(button);
				addChild(subMenu);
				subMenu->fromXML(node.toElement(),buttonParent);			//and parse the submenu
				button->setIcon(subMenu->IconPath());
				subMenu->hideButtons();
			} else if(node.nodeName()=="icon"){
				setIconPath(node.firstChild().nodeValue());
			}
		}
		node=node.nextSibling();
	}
	arrangeButtons();
}

void Menu::selectButton( int num )
{
	if(mSelectedButtonNum>=0){
		static_cast<RoundButton*>(find(mSelectedButtonNum))->setActive(false);
	}
	if(num!=BUTTON_DESELECT){
		int newButton;
		if((newButton=num%count())<0){
			//if newButton is a negative  value we have to get a positve value congruent newButton mod count()
			newButton=count()+newButton;
		}
		mSelectedButtonNum=newButton;
		ExtendedButton* temp=	static_cast<ExtendedButton*>(find(mSelectedButtonNum));
		temp->setActive(true);
		emit buttonSelected(temp->type());
	} else {
		mSelectedButtonNum=BUTTON_DESELECT;
		emit buttonSelected(0);
	}
}

QButton * Menu::selectedButton( )
{
	if(mSelectedButtonNum<0){
		return NULL;
	}
	return find(mSelectedButtonNum);
}

int Menu::insert( QButton * button, int id )
{
	connect(static_cast<RoundButton*>(button),SIGNAL(mouseIn(RoundButton*)),this,SLOT(slotMouseIn(RoundButton*)));
	connect(static_cast<RoundButton*>(button),SIGNAL(mouseOut(RoundButton*)),this,SLOT(slotMouseOut()));
	return QButtonGroup::insert(button,id);
}

void Menu::slotMouseIn(RoundButton* emitter)
{
	selectButton(emitter);
}

Menu * Menu::execute( )
{
	if(selectedButtonNum()!=BUTTON_DESELECT){
		CommandoButton* temp = static_cast<CommandoButton*>(selectedButton());
		selectButton(BUTTON_DESELECT);
		return temp->execute();
	}
	return NULL;	//Well, we shouldn't actually reach this place, as execute is only called if it is sure that a button was selected
}

void Menu::slotMouseOut()
{
	selectButton(BUTTON_DESELECT);
}

void Menu::selectButton( QButton * button )
{
	selectButton(id(button));
}

#include "menu.moc"
