/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "commandobutton.h"

#include <krun.h>

ExtendedButton::ExtendedButton( QWidget * parent )
	: RoundButton(parent)
{
}

CommandoButton::CommandoButton(QWidget* parent)
	: ExtendedButton(parent),mType(1)
{
}

CommandoButton::CommandoButton( QWidget * parent, const QDomElement & ownNode )
	: ExtendedButton(parent),mType(1)
{
	fromXML(ownNode);
}

CommandoButton::~CommandoButton()
{
}

void CommandoButton::fromXML(const QDomElement& ownNode )
{
	QDomNode bnode=ownNode.firstChild();
	while (!bnode.isNull()){
		if(bnode.nodeName() == "command"){
			setCommand(bnode.firstChild().nodeValue());
		} else if (bnode.nodeName() == "icon"){
			setIcon(bnode.firstChild().nodeValue());
		}
		bnode=bnode.nextSibling();
	}
}

Menu* CommandoButton::execute( )
{
		KRun::runCommand(command());
		return NULL;
}

/*
 * Implementation SubmenuButton
 */
 
Menu * SubmenuButton::execute( )
{
	return subMenu();
}

SubmenuButton::SubmenuButton( QWidget * parent )
	:ExtendedButton(parent),mType(2)
{
}

SubmenuButton::SubmenuButton( QWidget * parent, Menu * submenu )
	:ExtendedButton(parent),mSubMenu(submenu),mType(2)
{
}


SubmenuButton::~SubmenuButton()
{
}



#include "commandobutton.moc"
