/***************************************************************************
                          options.h  -  description
                             -------------------
    begin                : Wed May 3 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#include <qwidget.h>
#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>
#include <kconfig.h>
/**
  *@author Frank Schwanz
  */

class Options:public QObject
{
Q_OBJECT public:
  Options (QObject * parent = 0, const char *name = 0);
   ~Options ();
  bool scanAllHosts ()
  {
    return scanallhosts;
  };
  bool scanAllWorkgroups ()
  {
    return scanallworkgroups;
  };
  bool unmountAllOnExit ()
  {
    return unmountallonexit;
  };
  bool hideIpcShares ()
  {
    return hideipcshares;
  };
  bool hideDollarShares ()
  {
    return hidedollarshares;
  };
  bool showIpcShares ()
  {
    return !hideipcshares;
  };
  bool showDollarShares ()
  {
    return !hidedollarshares;
  };
  bool showPrinters ()
  {
    return !hideprinters;
  };
  bool exploreAfterMount ()
  {
    return exploreaftermount;
  };
  bool mntLastSessionShares ()
  {
    return mntlastsessionshares;
  };
  bool savePasswords ()
  {
    return savepasswords;
  };
  bool noPasswordDialog ()
  {
    return nopassworddialog;
  };
  bool cleanupOnUnmount ()
  {
    return cleanuponunmount;
  };
  int smbMountVersion ()
  {
    return smbmountversion;
  };
  void setScanAllHosts (bool s)
  {
    scanallhosts = s;
  };
  void setScanAllWorkgroups (bool s)
  {
    scanallworkgroups = s;
  };
  void setUnmountAllOnExit (bool s)
  {
    unmountallonexit = s;
  };
  void setHideIpcShares (bool s)
  {
    hideipcshares = s;
  };
  void setHidePrinters (bool s)
  {
    hideprinters = s;
  };
  void setHideDollarShares (bool s)
  {
    hidedollarshares = s;
  };
  void setMntLastSessionShares (bool s)
  {
    mntlastsessionshares = s;
  };
  void setSavePasswords (bool s)
  {
    savepasswords = s;
  };
  void setExploreAfterMount (bool s)
  {
    exploreaftermount = s;
  };
  void setSmbMountVersion (int s)
  {
    smbmountversion = s;
  };
  void setNoPasswordDialog (int s)
  {
    nopassworddialog = s;
  };
  void setCleanupOnUnmount (bool s)
  {
    cleanuponunmount = s;
  };
  char *firstHost ()
  {
    return hosts.first ();
  };
  char *nextHost ()
  {
    return hosts.next ();
  };
  void clearHosts ()
  {
    hosts.clear ();
  };
  void appendHost (const char *h)
  {
    hosts.append (h);
  };
  char *currentHost ()
  {
    return hosts.current ();
  };


  char *firstHostOfMntShares ()
  {
    return hosts_mntshares.first ();
  };
  char *nextHostOfMntShares ()
  {
    return hosts_mntshares.next ();
  };
  char *currentHostOfMntShares ()
  {
    return hosts_mntshares.current ();
  };

  char *currentShareToMount ()
  {
    return sharestomount.current ();
  };
  QString currentShareOfShareToMount ()
  {
    return ShareOf (sharestomount.current ());
  };
  QString currentHostOfShareToMount ()
  {
    return HostOf (sharestomount.current ());
  };
  char *firstShareToMount ()
  {
    return sharestomount.first ();
  };
  char *nextShareToMount ()
  {
    return sharestomount.next ();
  };
  void clearShareToMount ()
  {
    sharestomount.clear ();
    hosts_mntshares.clear ();
  };
  void appendShareToMount (QString wg, QString h, QString s);
  char *firstIpRange ()
  {
    return ipranges.first ();
  };
  char *nextIpRange ()
  {
    return ipranges.next ();
  };
  char *currentIpRange ()
  {
    return ipranges.current ();
  };
  void clearIpRanges ()
  {
    ipranges.clear ();
  };
  void appendIpRange (const char *i)
  {
    ipranges.append (i);
  };
  QString & mountPath ()
  {
    return mountpath;
  };
  void setMountPath (QString & m)
  {
    mountpath = m;
  };
  /**  */
  void readAll ();
  /**  */
  void saveAll ();
  void saveShareToMount ();
  /** Look for if share is to mount (LastSessionShares) */
  bool isToMount (QString sname);
  // save a ShareAccount save =0 for user and pw; 1 for user only, 2 for pw only
  void setShareAccount (const QString host, const QString share,
			const QString username, const QString password,
			bool ask_for_pw = true, int save = 0);
  bool getShareAccount (const QString host, const QString share,
			QString & username, QString & password, bool * ask);
  void setHostAccount (const QString host, const QString username,
		       const QString password, bool ask_for_pw =
		       true, int save = 0);
  bool getHostAccount (const QString host, QString & username,
		       QString & password, bool * ask);
  void setWorkgroupAccount (const QString wg, const QString username,
			    const QString password, bool ask_for_pw =
			    true, int save = 0);
  bool getWorkgroupAccount (const QString wg, QString & username,
			    QString & password);
private:
  struct share_account
  {
    bool ask_for_password;
    QString wgname;
    QString hostname;
    QString sharename;
    QString password;
    QString username;
  };
  struct host_account
  {
    bool ask_for_password;
    QString hostname;
    QString password;
    QString username;
  };
  struct wg_account
  {
    bool ask_for_password;
    QString wgname;
    QString password;
    QString username;
  };
  bool getPreferences (const char *group, const char *name,
		       QString * setting);
  /**  */
  QString ShareOf (QString stm);
  QString HostOf (QString stm);

  QString mountpath;
  int smbmountversion;
  QStrList hosts;
  QStrList hosts_mntshares;
  QStrList ipranges;
  QList < host_account > *host_accounts;
  QList < wg_account > *wg_accounts;
  QList < share_account > *share_accounts;
  bool scanallhosts;
  bool scanallworkgroups;
  bool unmountallonexit;
  bool hideipcshares;
  bool hideprinters;
  bool hidedollarshares;
  bool mntlastsessionshares;
  bool savepasswords;
  bool exploreaftermount;
  bool nopassworddialog;
  bool cleanuponunmount;
  QStrList sharestomount;
  const QString encryptStr (const QString aStr) const;
  const QString decryptStr (const QString aStr) const;
};

#endif
