/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/
#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <klocale.h>

//Separator for entries in command list
#define CMD_SEP "~"

void prefs::saveSlot()
{
    //write ~/.octaverc
     QString rcfilen=QDir::home().path()+"/.octaverc";
     QFile rcfile(rcfilen);
     if( rcfile.exists() )
     {
	 if ( rcfile.open( IO_WriteOnly ) )
	 {
	     QTextStream stream( &rcfile );
	     stream << octavercLine->text();
	 }
     }
     rcfile.close();
     
    //save changes to config
    KConfig *cfg;
    cfg=kapp->config();
    cfg->setGroup("Paths");
    cfg->writeEntry("octave", octaveLine->text());
    cfg->writeEntry("docs", docsLine->text());

    QString cmds;
    for(int a=1; a< (cmdList->numItemsVisible()  ); a++)cmds.append(CMD_SEP+cmdList->text(a) );
    cfg->setGroup("Commands");
    cfg->writeEntry("cmds", cmds);    
    cfg->sync();
    emit configChanged();	//so we can read new settings without restart
}


void prefs::init()
{
    KConfig *cfg;
    cfg=kapp->config();
    cfg->setGroup("Paths");
    octaveLine->setText( cfg->readEntry("octave") );
    docsLine->setText( cfg->readEntry("docs"));        
    
    cfg->setGroup("Commands");
    const QStringList lst=QStringList::split(CMD_SEP, cfg->readEntry("cmds") );
    cmdList->insertStringList(lst,-1 );

    //read ~/.octaverc
     QString rcfilen=QDir::home().path()+"/.octaverc";
     QFile rcfile(rcfilen);
     QString rcline="";
     if( rcfile.exists() )
     {
	 if ( rcfile.open( IO_ReadOnly ) )
	 {
	     QTextStream stream( &rcfile );
	     while ( !stream.eof() )
	     {
	       rcline.append( stream.readLine() +"\n");           // line of text excluding '\n'
	     }
	 }
     }
     rcfile.close();
     octavercLine->setText(rcline);
}

void prefs::browseOctaveSlot()
{
 KURL url=KFileDialog::getOpenURL(QString::null,
         QString("octave"), this, i18n("octave path..."));
    if(! url.path().isNull() )octaveLine->setText( url.path() );

}

void prefs::browseDocsSlot()
{
 KURL url=KFileDialog::getOpenURL(QString::null,
         QString("octave_toc.html|Octave htmlfiles"), this, i18n("Document path..."));
    if(! url.path().isNull() )docsLine->setText( url.path() );
}

void prefs::addSlot()
{
    if( cmdLine->text() !="")cmdList->insertItem( cmdLine->text() );
    cmdLine->setText("");
}

void prefs::delSlot()
{
    cmdList->removeItem( cmdList->currentItem() );
}
