/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/
#include <klibloader.h>
#include <klocale.h>
#include <kparts/factory.h> 
#include <kparts/mainwindow.h>
#include <kparts/part.h>
#include <kconfig.h>               
#include <qfileinfo.h>
#include <qdir.h>
#include <kapplication.h>

#include "dirview/dirview.h"

#include <stdlib.h>			//needed to export shell


void MainWidget::init()
{
    KConfig *cfg;
    cfg=kapp->config();
    cfg->setGroup("Paths");    
    QString shell = cfg->readEntry("octave").latin1();
    if( cfg->readEntry("octave").isNull() ) 
	shell ="octave";		//set shell to default if missing..stupid..?    
    setenv( "SHELL", shell.latin1() ,1);		//set the shell to octave-path, this way 					

					//user cannot exit octave and get a regular shell
    lo = new QVBoxLayout(octaveWidget);

    KLibFactory *factory = KLibLoader::self()->factory( "libkonsolepart" );
    if (factory)
    {
      // Create the part    
	QStringList args;
	args << "";				//by default no args
	konsole_part = static_cast<KParts::ReadOnlyPart*>( factory->create( octaveWidget, "Console", "TerminalEmulator", args ) );
	lo->addWidget( konsole_part->widget() );
	konsole_part->widget()->setFocus();
    }
    else
      qDebug("No lib found, check that kdebase is properly installed!");
  
    //file browser
    lo2 = new QVBoxLayout(browserWidget);
    DirectoryView *mw = new DirectoryView(browserWidget);
    connect( mw, SIGNAL( openFile(QString) ), this, SLOT( openFile(QString) ) );	//open file from browser
    connect ( konsole_part, SIGNAL(destroyed()), qApp, SLOT(quit()) );			//fast quit (CTRL+D) 

    lo2->addWidget(mw);

    //init commandlist
   updateConfig();
}

void MainWidget::destroy()
{
/*
    No need!
 if(konsole_part->widget() != NULL)
    konsole_part->writeStream( QCString("exit") );	//be nice to konsle-part?
*/
}

void MainWidget::sendCmdSlot( QString * cmd )
{

  QString clr="";			//clear the command in command window (by  executing it..)
  konsole_part->writeStream( QCString("") );
   
  QString t="";
   t.append( cmd->latin1() );
  konsole_part->writeStream( QCString(t) );
#ifdef DEBUG_S
  qDebug("Got cmd");
  qDebug(t.latin1());
#endif
}


//not possible with the part...?
void MainWidget::insert( QString * cmd )
{

    QString t="";
    t.append(cmd->latin1());	 
//    octaveIF->appendCMD(t);
    konsole_part->widget()->setFocus();

}

//part was destroyed
// Make it alive agan.. bad thing ?
// At least inform of a crash in octave ? (or exit..)
void MainWidget::slotDestroyed()
{
    qApp->quit();
}

void MainWidget::sendToSlot( QListBoxItem * item )
{
#ifdef DEBUG_S
    qDebug("Listbox command");
#endif
    item=item; 			//ignore warning while commented bellow!
    if(!commandList->currentText().isNull() )
	konsole_part->writeStream( QCString(commandList->currentText()) );		

    if(!konsole_part->widget()->hasFocus() )
	konsole_part->widget()->setFocus();
}

//send this signal out from this class (to mainwindow..)
void MainWidget::openFile( QString file)
{
//    qDebug(file.latin1() );
    KURL p = KURL(file);
    QString *t = new QString( "cd " + p.directory());
    sendCmdSlot(t);
    emit fileSelected( file );
}


// in a own function so it can be called when config changes during runtime.
void MainWidget::updateConfig()
{
    KConfig *cfg;
    cfg=kapp->config();

    cfg->setGroup("Commands");
    const QStringList lst=QStringList::split("~" , cfg->readEntry("cmds") );
    if(!lst.empty() )
    {
	commandList->clear();
	commandList->insertStringList(lst,-1 );    
    }
}
