<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 11.04.2006
 *
 * Version 0.1
 * This Class is for language work
 ******************************/
 
class language {
	var $CLASS = array();
	var $default_lang = "en";
	var $get = array(); // array with languagetokens
	
	var $sys = array(); // array with syslanguagetokens

	function start(&$CLASS,$language) {
		$this->CLASS =& $CLASS;

		// load syslangtokens to array
		$this->load_sys_lang($language);
		
		// set userlanguage if available
		if($_SESSION['language'] != "") {
			$language = $_SESSION['language'];
		}
		
		$this->load_language($language);
		
		return 0;
	}

	function load_language($language) {
		if(is_file("system/language/lang_" . $language . ".php")) {
			include("system/language/lang_" . $language . ".php");
		} elseif(is_file("system/language/lang_" . $this->default_lang . ".php")) {
			include("system/language/lang_" . $this->default_lang . ".php");
			$language = $this->default_lang;
		} else {
			exit("LANGUAGE: '" . $language . "' NOT FOUND!");
		}
		
		$this->get = $languagetoken[$language];
		unset($languagetoken);
	}
	
	function load_sys_lang($language) {
		if(is_file("system/language/lang_" . $language . ".php")) {
			include("system/language/lang_" . $language . ".php");
		} elseif(is_file("system/language/lang_" . $this->default_lang . ".php")) {
			include("system/language/lang_" . $this->default_lang . ".php");
			$language = $this->default_lang;
		} else {
			exit("LANGUAGE: '" . $language . "' NOT FOUND!");
		}
		
		$this->sys = $languagetoken[$language];
		unset($languagetoken);
	}
	
	// dropdown with available languages
	function lang_dropdown($name = "language",$default = "") {
		if(!is_array($this->CLASS['vars']['knowledgeroot']['availablelanguages'])) {
			$this->CLASS['vars']['knowledgeroot']['availablelanguages'] = array($this->CLASS['vars']['knowledgeroot']['language']);
		}
		
		if($default == "") {
			$default = $this->CLASS['vars']['knowledgeroot']['language'];
		}
	
		$out = "<select name=\"".$name."\">\n";
		
		foreach($this->CLASS['vars']['knowledgeroot']['availablelanguages'] as $key => $value) {
			if($value == $default) {
				$selected = "selected";
			}
			
			$out .= "\t<option value=\"".$value."\" $selected>".$value."</option>\n";
			$selected = "";
		}

		$out .= "</select>\n";
		return $out;
	}
}

?>